/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.slicensplice;

import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskBlock;
import crazypants.enderio.base.machine.render.RenderMappers;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.machines.config.config.ClientConfig;
import crazypants.enderio.machines.machine.slicensplice.ContainerSliceAndSplice;
import crazypants.enderio.machines.machine.slicensplice.GuiSliceAndSplice;
import crazypants.enderio.machines.machine.slicensplice.ParticleBloodDrip;
import crazypants.enderio.machines.machine.slicensplice.TileSliceAndSplice;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSliceAndSplice
extends AbstractPoweredTaskBlock<TileSliceAndSplice>
implements IPaintable.ISolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockSliceAndSplice create(@Nonnull IModObject modObject) {
        BlockSliceAndSplice result = new BlockSliceAndSplice(modObject);
        result.init();
        return result;
    }

    protected BlockSliceAndSplice(@Nonnull IModObject modObject) {
        super(modObject);
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    @Override
    @Nullable
    public Container getServerGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileSliceAndSplice te) {
        return new ContainerSliceAndSplice(player.field_71071_by, te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public GuiScreen getClientGuiElement(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing facing, int param1, @Nonnull TileSliceAndSplice te) {
        return new GuiSliceAndSplice(player.field_71071_by, te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@Nonnull IBlockState bs, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        TileSliceAndSplice te = (TileSliceAndSplice)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null && this.isActive((IBlockAccess)world, pos)) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            EnumFacing front = te.getFacing();
            int count = rand.nextInt(3) + 2;
            for (int i = 0; i < count; ++i) {
                double px = (double)x + 0.5 + (double)front.func_82601_c() * 0.5;
                double pz = (double)z + 0.5 + (double)front.func_82599_e() * 0.5;
                double v = 0.1;
                double vx = 0.0;
                double vz = 0.0;
                if (front == EnumFacing.NORTH || front == EnumFacing.SOUTH) {
                    px += (double)rand.nextFloat() * 0.6 - 0.275;
                    vz += front == EnumFacing.NORTH ? -v : v;
                } else {
                    pz += (double)rand.nextFloat() * 0.6 - 0.275;
                    vx += front == EnumFacing.WEST ? -v : v;
                }
                if (rand.nextFloat() > 0.3f) {
                    Particle fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), px, (double)y + 0.7, pz, vx, 0.0, vz, new int[]{0});
                    if (fx == null) continue;
                    float[] colors = new float[3];
                    Color.RGBtoHSB(80, 20, 20, colors);
                    colors[1] = Math.max(0.0f, colors[1] + rand.nextFloat() * 0.4f - 0.4f);
                    colors[2] = colors[2] + (rand.nextFloat() * 0.2f - 0.1f);
                    Color color = Color.getHSBColor(colors[0], colors[1], colors[2]);
                    if (((Boolean)ClientConfig.bloodEnabled.get()).booleanValue()) {
                        fx.func_70538_b((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                    } else {
                        fx.func_70538_b((float)color.getGreen() / 255.0f, (float)color.getRed() / 255.0f, (float)color.getBlue() / 255.0f);
                    }
                    fx.func_70543_e(0.25f);
                    continue;
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleBloodDrip(world, px + (double)front.func_82601_c() * 0.1, (double)y + 0.325, pz + (double)front.func_82599_e() * 0.1, front));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.SOUL_MAPPER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.SOUL_MAPPER;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileSliceAndSplice tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive());
    }
}

