/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.reservoir;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.ManagedTESR;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.machines.machine.reservoir.BlockReservoirBase;
import crazypants.enderio.machines.machine.reservoir.TileReservoirBase;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ReservoirRenderer
extends ManagedTESR<TileReservoirBase> {
    public ReservoirRenderer(BlockReservoirBase res) {
        super((Block)res);
    }

    protected boolean shouldRender(@Nonnull TileReservoirBase te, @Nonnull IBlockState blockState, int renderPass) {
        return !te.getTank().isEmpty();
    }

    protected void renderTileEntity(@Nonnull TileReservoirBase te, @Nonnull IBlockState blockState, float partialTicks, int destroyStage) {
        NNList<RenderFace> faces = this.computeGeometry(te.getTank(), te.func_145831_w(), te.func_174877_v());
        if (faces.isEmpty()) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        for (int i = 0; i <= 1; ++i) {
            GlStateManager.func_187407_a((GlStateManager.CullFace)(i == 0 ? GlStateManager.CullFace.FRONT : GlStateManager.CullFace.BACK));
            buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            faces.apply((NNList.Callback)new RenderFaces(buffer));
            tessellator.func_78381_a();
        }
    }

    public void renderTileEntityFast(@Nonnull TileReservoirBase te, double x, double y, double z, float partialTicks, int destroyStage, float partial, @Nonnull BufferBuilder buffer) {
        if (NullHelper.untrust((Object)((Object)te)) != null && te.func_145830_o() && !te.func_145837_r() && !te.getTank().isEmpty()) {
            buffer.func_178969_c(x, y, z);
            this.computeGeometry(te.getTank(), te.func_145831_w(), te.func_174877_v()).apply((NNList.Callback)new RenderFacesFast(buffer));
            buffer.func_178969_c(0.0, 0.0, 0.0);
        }
    }

    private BoundingBox mkFace(@Nonnull boolean[][][] merge, @Nonnull EnumFacing face, float fullness, float fullness2, boolean gas) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        switch (face) {
            case DOWN: {
                if (merge[1][0][1]) {
                    if (fullness2 == 1.0f) {
                        return null;
                    }
                    minY = 0.0;
                } else {
                    minY = 0.001;
                }
                double d = merge[0][1][1] ? (merge[0][0][1] ? -0.001 : 0.0) : (minX = 0.001);
                double d2 = merge[2][1][1] ? (merge[2][0][1] ? 1.001 : 1.0) : (maxX = 0.999);
                double d3 = merge[1][1][0] ? (merge[1][0][0] ? -0.001 : 0.0) : (minZ = 0.001);
                maxZ = merge[1][1][2] ? (merge[1][0][2] ? 1.001 : 1.0) : 0.999;
                break;
            }
            case EAST: {
                if (merge[2][1][1]) {
                    if (fullness <= fullness2) {
                        return null;
                    }
                    maxX = 1.0;
                } else {
                    maxX = 0.999;
                }
                double d = merge[1][0][1] ? (merge[2][0][1] ? -0.001 : 0.0) : (minY = 0.001);
                double d4 = merge[1][2][1] ? (merge[2][2][1] ? 1.001 : 1.0) : (maxY = 0.999);
                double d5 = merge[1][1][0] ? (merge[2][1][0] ? -0.001 : 0.0) : (minZ = 0.001);
                maxZ = merge[1][1][2] ? (merge[2][1][2] ? 1.001 : 1.0) : 0.999;
                break;
            }
            case NORTH: {
                if (merge[1][1][0]) {
                    if (fullness <= fullness2) {
                        return null;
                    }
                    minZ = 0.0;
                } else {
                    minZ = 0.001;
                }
                double d = merge[0][1][1] ? (merge[0][1][0] ? -0.001 : 0.0) : (minX = 0.001);
                double d6 = merge[2][1][1] ? (merge[2][1][0] ? 1.001 : 1.0) : (maxX = 0.999);
                double d7 = merge[1][0][1] ? (merge[1][0][0] ? -0.001 : 0.0) : (minY = 0.001);
                maxY = merge[1][2][1] ? (merge[1][2][0] ? 1.001 : 1.0) : 0.999;
                break;
            }
            case SOUTH: {
                if (merge[1][1][2]) {
                    if (fullness <= fullness2) {
                        return null;
                    }
                    maxZ = 1.0;
                } else {
                    maxZ = 0.999;
                }
                double d = merge[0][1][1] ? (merge[0][1][2] ? -0.001 : 0.0) : (minX = 0.001);
                double d8 = merge[2][1][1] ? (merge[2][1][2] ? 1.001 : 1.0) : (maxX = 0.999);
                double d9 = merge[1][0][1] ? (merge[1][0][2] ? -0.001 : 0.0) : (minY = 0.001);
                maxY = merge[1][2][1] ? (merge[1][2][2] ? 1.001 : 1.0) : 0.999;
                break;
            }
            case UP: {
                if (merge[1][2][1]) {
                    if (fullness2 > 0.0f && fullness == 1.0f) {
                        return null;
                    }
                    maxY = 1.0;
                } else {
                    maxY = 0.999;
                }
                double d = merge[0][1][1] ? (merge[0][2][1] ? -0.001 : 0.0) : (minX = 0.001);
                double d10 = merge[2][1][1] ? (merge[2][2][1] ? 1.001 : 1.0) : (maxX = 0.999);
                double d11 = merge[1][1][0] ? (merge[1][2][0] ? -0.001 : 0.0) : (minZ = 0.001);
                maxZ = merge[1][1][2] ? (merge[1][2][2] ? 1.001 : 1.0) : 0.999;
                break;
            }
            case WEST: {
                if (merge[0][1][1]) {
                    if (fullness <= fullness2) {
                        return null;
                    }
                    minX = 0.0;
                } else {
                    minX = 0.001;
                }
                double d = merge[1][0][1] ? (merge[0][0][1] ? -0.001 : 0.0) : (minY = 0.001);
                double d12 = merge[1][2][1] ? (merge[0][2][1] ? 1.001 : 1.0) : (maxY = 0.999);
                double d13 = merge[1][1][0] ? (merge[0][1][0] ? -0.001 : 0.0) : (minZ = 0.001);
                maxZ = merge[1][1][2] ? (merge[0][1][2] ? 1.001 : 1.0) : 0.999;
                break;
            }
        }
        if (face != EnumFacing.DOWN) {
            if (fullness2 > 0.0f && face != EnumFacing.UP) {
                minY = maxY * (double)fullness2;
            }
            maxY *= (double)fullness;
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected NNList<RenderFace> computeGeometry(@Nonnull SmartTank tank, @Nonnull World world, @Nonnull BlockPos pos) {
        FluidStack fluid = tank.getFluid();
        if (fluid == null) {
            return NNList.emptyList();
        }
        float[][][] full = new float[3][3][3];
        boolean[][][] merge = new boolean[3][3][3];
        merge[1][1][1] = true;
        for (int dx = 0; dx < 3; ++dx) {
            for (int dy = 0; dy < 3; ++dy) {
                for (int dz = 0; dz < 3; ++dz) {
                    FluidStack fluid2;
                    TileReservoirBase reservoir;
                    BlockPos pos2 = pos.func_177982_a(dx - 1, dy - 1, dz - 1);
                    if (merge[dx][dy][dz] || world.func_180495_p(pos2).func_177230_c() != this.block || (reservoir = (TileReservoirBase)((Object)BlockReservoirBase.getAnyTileEntity((IBlockAccess)world, (BlockPos)pos2, TileReservoirBase.class))) == null || (fluid2 = reservoir.getTank().getFluid()) == null || fluid2.getFluid() != fluid.getFluid()) continue;
                    full[dx][dy][dz] = reservoir.getTank().getFilledRatio();
                    merge[dx][dy][dz] = true;
                }
            }
        }
        TextureAtlasSprite icon = RenderUtil.getStillTexture((FluidStack)fluid);
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        int brightness = world.func_175626_b(pos, fluid.getFluid().getLuminosity(fluid));
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int color = fluid.getFluid().getColor(fluid);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        NNList faces = new NNList();
        NNList.NNIterator facings = NNList.FACING.fastIterator();
        while (facings.hasNext()) {
            float fullness1;
            EnumFacing dir = (EnumFacing)facings.next();
            Vec3i vec = dir.func_176730_m();
            float fullness0 = tank.getFilledRatio();
            BoundingBox bb = this.mkFace(merge, dir, fullness0, fullness1 = full[vec.func_177958_n() + 1][vec.func_177956_o() + 1][vec.func_177952_p() + 1], fluid.getFluid().isGaseous(fluid));
            if (bb == null) continue;
            float minVx = minV;
            float maxVx = maxV;
            if (dir.func_176740_k() != EnumFacing.Axis.Y) {
                minVx = icon.func_94207_b((double)((1.0f - fullness0) * 16.0f));
                maxVx = icon.func_94207_b((double)((1.0f - fullness1) * 16.0f));
            }
            faces.add((Object)new RenderFace(bb, dir, minU, maxU, minVx, maxVx, r, g, b, a, l1, l2));
        }
        return faces;
    }

    private static final class RenderFace {
        @Nonnull
        final BoundingBox bb;
        @Nonnull
        final EnumFacing face;
        final float minU;
        final float maxU;
        final float minV;
        final float maxV;
        final float r;
        final float g;
        final float b;
        final float a;
        final int light1;
        final int light2;

        protected RenderFace(@Nonnull BoundingBox bb, @Nonnull EnumFacing face, float minU, float maxU, float minV, float maxV, float r, float g, float b, float a, int light1, int light2) {
            this.bb = bb;
            this.face = face;
            this.minU = minU;
            this.maxU = maxU;
            this.minV = minV;
            this.maxV = maxV;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            this.light1 = light1;
            this.light2 = light2;
        }
    }

    private static final class RenderFaces
    implements NNList.Callback<RenderFace> {
        @Nonnull
        private final BufferBuilder buffer;

        public RenderFaces(@Nonnull BufferBuilder buffer) {
            this.buffer = buffer;
        }

        public void apply(@Nonnull RenderFace e) {
            for (Vertex v : e.bb.getCornersWithUvForFace(e.face, e.minU, e.maxU, e.minV, e.maxV)) {
                this.buffer.func_181662_b(v.x(), v.y(), v.z()).func_187315_a((double)v.u(), (double)v.v()).func_181666_a(e.r, e.g, e.b, e.a).func_181663_c(v.nx(), v.ny(), v.nz()).func_181675_d();
            }
        }
    }

    private static final class RenderFacesFast
    implements NNList.Callback<RenderFace> {
        @Nonnull
        private final BufferBuilder buffer;

        public RenderFacesFast(@Nonnull BufferBuilder buffer) {
            this.buffer = buffer;
        }

        public void apply(@Nonnull RenderFace e) {
            for (Vertex v : e.bb.getCornersWithUvForFace(e.face, e.minU, e.maxU, e.minV, e.maxV)) {
                this.buffer.func_181662_b(v.x(), v.y(), v.z()).func_181666_a(e.r, e.g, e.b, e.a).func_187315_a((double)v.u(), (double)v.v()).func_187314_a(e.light1, e.light2).func_181675_d();
            }
        }
    }
}

