/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.ILocalizable;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.TileEntityEio;
import crazypants.enderio.base.conduit.ConduitDisplayMode;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.facade.EnumFacadeType;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitConnectorType;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.base.conduit.geom.Offsets;
import crazypants.enderio.base.conduit.registry.ConduitRegistry;
import crazypants.enderio.base.diagnostics.Prof;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.ITileFilterContainer;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.interfaces.INotifier;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.conduits.autosave.HandleIConduit;
import crazypants.enderio.conduits.capability.CapabilityUpgradeHolder;
import crazypants.enderio.conduits.conduit.BlockConduitBundle;
import crazypants.enderio.conduits.conduit.IConduitComponent;
import crazypants.enderio.conduits.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.conduits.render.ConduitRenderMapper;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

@Storable
public class TileConduitBundle
extends TileEntityEio
implements IConduitBundle,
IConduitComponent.IConduitComponentProvider,
ITileFilterContainer,
INotifier {
    @Store(handler=HandleIConduit.List.class)
    @Nonnull
    private CopyOnWriteArrayList<IConduit> conduits = new CopyOnWriteArrayList();
    private final List<IServerConduit> serverConduits = new CopyOnWriteArrayList<IServerConduit>();
    private List<IClientConduit> clientConduits;
    @Store
    @Nonnull
    private EnumFacadeType facadeType = EnumFacadeType.BASIC;
    private final List<CollidableComponent> cachedCollidables = new CopyOnWriteArrayList<CollidableComponent>();
    private final List<CollidableComponent> cachedConnectors = new CopyOnWriteArrayList<CollidableComponent>();
    private boolean conduitsDirty = true;
    private boolean collidablesDirty = true;
    private boolean connectorsDirty = true;
    private boolean clientUpdated = false;
    private int lightOpacityOverride = -1;
    @SideOnly(value=Side.CLIENT)
    @Nullable
    private IConduitBundle.FacadeRenderState facadeRenderAs;
    private ConduitDisplayMode lastMode = ConduitDisplayMode.ALL;

    public TileConduitBundle() {
        this.field_145854_h = ConduitRegistry.getConduitModObjectNN().getBlockNN();
    }

    @Override
    @Nonnull
    public BlockPos getLocation() {
        return this.func_174877_v();
    }

    @Override
    public void dirty() {
        this.conduitsDirty = true;
        this.collidablesDirty = true;
    }

    public boolean shouldRenderInPass(int arg0) {
        if (this.getPaintSource() != null && this.getPaintSource().func_185914_p() && !YetaUtil.isFacadeHidden(this, EnderIO.proxy.getClientPlayer())) {
            return false;
        }
        return super.shouldRenderInPass(arg0);
    }

    @Override
    @Nonnull
    public World getBundleworld() {
        return this.func_145831_w();
    }

    @Override
    public int getInternalRedstoneSignalForColor(@Nonnull DyeColor col) {
        IRedstoneConduit redCon = this.getConduit(IRedstoneConduit.class);
        if (redCon != null) {
            return redCon.getRedstoneSignalForColor(col);
        }
        return 0;
    }

    @Override
    public boolean handleFacadeClick(@Nonnull World world1, @Nonnull BlockPos placeAt, @Nonnull EntityPlayer player, @Nonnull EnumFacing opposite, @Nonnull ItemStack stack, @Nonnull EnumHand hand, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        IBlockState facadeID = PaintUtil.getSourceBlock(player.func_184586_b(hand));
        if (facadeID == null) {
            return false;
        }
        int facadeType1 = player.func_184586_b(hand).func_77952_i();
        if (this.hasFacade()) {
            if (!YetaUtil.isSolidFacadeRendered(this, player) || this.facadeEquals(facadeID, facadeType1)) {
                return false;
            }
            if (!this.field_145850_b.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                ItemStack drop = new ItemStack(ModObject.itemConduitFacade.getItemNN(), 1, EnumFacadeType.getMetaFromType(this.getFacadeType()));
                PaintUtil.setSourceBlock(drop, this.getPaintSource());
                if (!player.field_71071_by.func_70441_a(drop)) {
                    ItemUtil.spawnItemInWorldWithRandomMotion((World)this.field_145850_b, (ItemStack)drop, (BlockPos)this.field_174879_c, (float)hitX, (float)hitY, (float)hitZ, (float)1.2f);
                }
            }
        }
        this.setFacadeType(EnumFacadeType.getTypeFromMeta(facadeType1));
        this.setPaintSource(facadeID);
        if (!this.field_145850_b.field_72995_K) {
            ConduitUtil.playPlaceSound(facadeID.func_177230_c().func_185467_w(), this.field_145850_b, this.field_174879_c);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
        this.func_70296_d();
        return true;
    }

    private boolean facadeEquals(@Nonnull IBlockState b, int facadeType1) {
        IBlockState a = this.getPaintSource();
        if (a == null) {
            return false;
        }
        if (a.func_177230_c() != b.func_177230_c()) {
            return false;
        }
        if (this.getFacadeType().ordinal() != facadeType1) {
            return false;
        }
        return a.func_177230_c().func_176201_c(a) == b.func_177230_c().func_176201_c(b);
    }

    @Override
    @Nonnull
    public String[] getConduitProbeData(@Nonnull EntityPlayer player, @Nullable EnumFacing side) {
        StringBuilder sb = new StringBuilder();
        for (IConduit iConduit : this.getConduits()) {
            sb.append(iConduit.getConduitProbeInfo(player));
        }
        return sb.toString().split("\n");
    }

    @Override
    protected void onBeforeNbtWrite() {
        this.conduits = this.serverConduits != null ? new CopyOnWriteArrayList<IServerConduit>(this.serverConduits) : new CopyOnWriteArrayList();
    }

    @Override
    protected void onAfterNbtRead() {
        super.onAfterNbtRead();
        if (this.field_145850_b.field_72995_K) {
            ConduitRegistry.sort(this.conduits);
            CopyOnWriteArrayList<IClientConduit> temp = new CopyOnWriteArrayList<IClientConduit>();
            for (IConduit c : this.conduits) {
                if (!(c instanceof IClientConduit)) continue;
                c.setBundle(this);
                temp.add((IClientConduit)c);
            }
            BlockStateWrapperConduitBundle.ConduitCacheKey oldHashCode = new BlockStateWrapperConduitBundle.ConduitCacheKey();
            BlockStateWrapperConduitBundle.ConduitCacheKey newHashCode = new BlockStateWrapperConduitBundle.ConduitCacheKey();
            TileConduitBundle.makeConduitHashCode(this.getClientConduits(), oldHashCode);
            TileConduitBundle.makeConduitHashCode(temp, newHashCode);
            if (this.func_145830_o() && this.func_145831_w().field_72995_K && oldHashCode.hashCode() != newHashCode.hashCode()) {
                this.clientUpdated = true;
            }
            this.clientConduits = temp;
            this.conduits = new CopyOnWriteArrayList();
        } else {
            this.serverConduits.clear();
            for (IConduit c : this.conduits) {
                if (!(c instanceof IServerConduit)) continue;
                c.setBundle(this);
                this.serverConduits.add((IServerConduit)c);
            }
            this.conduits.clear();
        }
        this.cachedCollidables.clear();
    }

    @Override
    public boolean hasFacade() {
        return this.getPaintSource() != null;
    }

    @Override
    public void setPaintSource(@Nullable IBlockState paintSource) {
        super.setPaintSource(paintSource);
        IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
        IBlockState newBs = bs.func_177226_a(BlockConduitBundle.OPAQUE, (Comparable)Boolean.valueOf(this.getLightOpacity() > 0));
        if (bs == newBs) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), newBs.func_177231_a(BlockConduitBundle.OPAQUE));
        }
        this.field_145850_b.func_175656_a(this.func_174877_v(), newBs);
        this.forceUpdatePlayers();
    }

    @Override
    public void setFacadeType(@Nonnull EnumFacadeType type) {
        this.facadeType = type;
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public EnumFacadeType getFacadeType() {
        return this.facadeType;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IConduitBundle.FacadeRenderState getFacadeRenderedAs() {
        IConduitBundle.FacadeRenderState ret = this.facadeRenderAs;
        if (ret == null) {
            ret = this.facadeRenderAs = IConduitBundle.FacadeRenderState.NONE;
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setFacadeRenderAs(IConduitBundle.FacadeRenderState state) {
        this.facadeRenderAs = state;
    }

    @Override
    public int getLightOpacity() {
        if (this.field_145850_b.field_72995_K && this.lightOpacityOverride != -1) {
            return this.lightOpacityOverride;
        }
        IBlockState paintSource = this.getPaintSource();
        if (paintSource != null) {
            if (this.getFacadeType().isTransparent() && ((Boolean)ConduitConfig.transparentFacadesLetThroughBeaconBeam.get()).booleanValue()) {
                return Math.min(paintSource.func_185891_c(), 14);
            }
            return paintSource.func_185891_c();
        }
        return 0;
    }

    @Override
    public void setLightOpacityOverride(int opacity) {
        this.lightOpacityOverride = opacity;
    }

    @Override
    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            for (IServerConduit conduit : this.getServerConduits()) {
                conduit.onChunkUnload();
            }
        }
    }

    @Override
    public void doUpdate() {
        Prof.start((IBlockAccess)this.func_145831_w(), "tick");
        for (IConduit iConduit : this.getConduits()) {
            Prof.next((IBlockAccess)this.func_145831_w(), "", (Object)iConduit);
            iConduit.updateEntity(this.field_145850_b);
        }
        if (!this.field_145850_b.field_72995_K && this.conduitsDirty) {
            Prof.next((IBlockAccess)this.func_145831_w(), "neighborUpdate");
            this.doConduitsDirty();
        }
        if (this.field_145850_b.field_72995_K) {
            Prof.next((IBlockAccess)this.func_145831_w(), "clientTick");
            this.updateEntityClient();
        }
        Prof.stop((IBlockAccess)this.func_145831_w());
    }

    private void doConduitsDirty() {
        IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
        this.field_145850_b.func_190524_a(this.field_174879_c, this.func_145838_q(), this.field_174879_c);
        this.func_70296_d();
        this.forceUpdatePlayers();
        this.conduitsDirty = false;
    }

    private void updateEntityClient() {
        ConduitDisplayMode curMode;
        boolean markForUpdate = false;
        if (this.clientUpdated) {
            markForUpdate = true;
            this.clientUpdated = false;
        }
        IConduitBundle.FacadeRenderState curRS = this.getFacadeRenderedAs();
        IConduitBundle.FacadeRenderState rs = ConduitUtil.getRequiredFacadeRenderState(this, (EntityPlayer)NullHelper.notnull((Object)EnderIO.proxy.getClientPlayer(), (String)"Proxy#getClientPlayer"));
        if (((Boolean)ConduitConfig.updateLightingWhenHidingFacades.get()).booleanValue()) {
            int shouldBeLO;
            int n = shouldBeLO = rs == IConduitBundle.FacadeRenderState.FULL ? -1 : 0;
            if (this.lightOpacityOverride != shouldBeLO) {
                this.setLightOpacityOverride(shouldBeLO);
                this.field_145850_b.func_175664_x(this.func_174877_v());
            }
        }
        if (curRS != rs) {
            this.setFacadeRenderAs(rs);
            if (!ConduitUtil.forceSkylightRecalculation(this.field_145850_b, this.func_174877_v())) {
                markForUpdate = true;
            }
        }
        if (!((curMode = ConduitDisplayMode.getDisplayMode(EnderIO.proxy.getClientPlayer().func_184614_ca())) == this.lastMode || this.lastMode.isAll() && curMode.isAll())) {
            markForUpdate = true;
        }
        this.lastMode = curMode;
        if (markForUpdate) {
            this.updateBlock();
        }
    }

    @Override
    public void onNeighborBlockChange(@Nonnull Block blockId) {
        if (!this.field_145850_b.field_72995_K) {
            boolean needsUpdate = false;
            for (IServerConduit conduit : this.getServerConduits()) {
                needsUpdate |= conduit.onNeighborBlockChange(blockId);
            }
            if (needsUpdate) {
                this.dirty();
            }
        }
    }

    @Override
    public void onNeighborChange(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos posIn, @Nonnull BlockPos neighbor) {
        if (!this.field_145850_b.field_72995_K) {
            boolean needsUpdate = false;
            for (IServerConduit conduit : this.getServerConduits()) {
                needsUpdate |= conduit.onNeighborChange(neighbor);
            }
            if (needsUpdate) {
                this.dirty();
            }
        }
    }

    @Nonnull
    public TileConduitBundle getEntity() {
        return this;
    }

    @Override
    public boolean hasType(Class<? extends IConduit> type) {
        return this.getConduit(type) != null;
    }

    @Override
    public <T extends IConduit> T getConduit(Class<T> type) {
        if (type == null) {
            return null;
        }
        for (IConduit iConduit : this.getConduits()) {
            if (!type.isInstance(iConduit)) continue;
            return (T)iConduit;
        }
        return null;
    }

    @Override
    public boolean addConduit(IServerConduit conduit) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.getServerConduits().size() < 9) {
            conduit.setBundle(this);
            this.getServerConduits().add(conduit);
            conduit.onAddedToBundle();
            this.dirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeConduit(IConduit conduit) {
        if (conduit instanceof IServerConduit) {
            return this.removeConduit((IServerConduit)conduit, true);
        }
        return false;
    }

    public boolean removeConduit(IServerConduit conduit, boolean notify) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        conduit.onBeforeRemovedFromBundle();
        if (this.getServerConduits().remove(conduit)) {
            conduit.onAfterRemovedFromBundle();
            conduit.setBundle(null);
            if (notify) {
                this.dirty();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onBlockRemoved() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        while (!this.serverConduits.isEmpty()) {
            this.removeConduit(this.serverConduits.get(0), false);
        }
        this.dirty();
    }

    @Override
    public Collection<IServerConduit> getServerConduits() {
        return this.serverConduits != null ? this.serverConduits : Collections.emptyList();
    }

    @Override
    public Collection<? extends IConduit> getConduits() {
        return (Collection)NullHelper.first((Object[])new List[]{this.field_145850_b.field_72995_K ? this.clientConduits : this.serverConduits, Collections.emptyList()});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Collection<IClientConduit> getClientConduits() {
        return this.clientConduits != null ? this.clientConduits : Collections.emptyList();
    }

    @Override
    @Nonnull
    public Offset getOffset(@Nonnull Class<? extends IConduit> type, @Nullable EnumFacing dir) {
        if (this.getConnectionCount(dir) < 2) {
            return Offset.NONE;
        }
        return Offsets.get(type, dir);
    }

    @Override
    public List<CollidableComponent> getCollidableComponents() {
        for (IConduit iConduit : this.getConduits()) {
            this.collidablesDirty = this.collidablesDirty || iConduit.haveCollidablesChangedSinceLastCall();
        }
        if (this.collidablesDirty) {
            this.connectorsDirty = true;
        }
        if (!this.collidablesDirty && !this.cachedCollidables.isEmpty()) {
            return this.cachedCollidables;
        }
        this.cachedCollidables.clear();
        for (IConduit iConduit : this.getConduits()) {
            this.cachedCollidables.addAll(iConduit.getCollidableComponents());
        }
        this.addConnectors(this.cachedCollidables);
        this.collidablesDirty = false;
        return this.cachedCollidables;
    }

    @Override
    public List<CollidableComponent> getConnectors() {
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        this.addConnectors(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void addConnectors(List<CollidableComponent> result) {
        if (this.getConduits().isEmpty()) {
            return;
        }
        for (IConduit iConduit : this.getConduits()) {
            boolean b = iConduit.haveCollidablesChangedSinceLastCall();
            this.collidablesDirty = this.collidablesDirty || b;
            this.connectorsDirty = this.connectorsDirty || b;
        }
        if (this.connectorsDirty || this.cachedConnectors.isEmpty()) {
            void var5_13;
            void var6_27;
            this.cachedConnectors.clear();
            ArrayList<CollidableComponent> coreBounds = new ArrayList<CollidableComponent>();
            ArrayList<CollidableComponent> arrayList = new ArrayList<CollidableComponent>();
            for (IConduit iConduit : this.getConduits()) {
                this.addConduitCores(coreBounds, iConduit);
                arrayList.addAll(iConduit.getCollidableComponents());
            }
            this.cachedConnectors.addAll(coreBounds);
            arrayList.addAll(coreBounds);
            HashSet<Class<? extends IConduit>> collidingTypes = new HashSet<Class<? extends IConduit>>();
            for (CollidableComponent collidableComponent : arrayList) {
                for (CollidableComponent collidableComponent2 : arrayList) {
                    if ("ColorController".equals(collidableComponent2.data) || "ColorController".equals(collidableComponent.data) || collidableComponent == collidableComponent2 || !collidableComponent.bound.intersects(collidableComponent2.bound)) continue;
                    collidingTypes.add(collidableComponent.conduitType);
                }
            }
            if (!collidingTypes.isEmpty()) {
                void var6_18;
                ArrayList<CollidableComponent> arrayList2 = new ArrayList<CollidableComponent>();
                for (Class clazz : collidingTypes) {
                    Object t = this.getConduit(clazz);
                    if (t == null) continue;
                    this.addConduitCores((List<CollidableComponent>)arrayList2, (IConduit)t);
                }
                Object var6_17 = null;
                for (CollidableComponent collidableComponent : arrayList2) {
                    if (var6_18 == null) {
                        BoundingBox boundingBox = collidableComponent.bound;
                        continue;
                    }
                    BoundingBox boundingBox = var6_18.expandBy(collidableComponent.bound);
                }
                if (var6_18 != null) {
                    BoundingBox boundingBox = var6_18.scale(1.05, 1.05, 1.05);
                    CollidableComponent collidableComponent = new CollidableComponent(null, boundingBox, null, (Object)ConduitConnectorType.INTERNAL);
                    this.cachedConnectors.add(collidableComponent);
                }
            }
            for (IConduit iConduit : this.getConduits()) {
                void var8_49;
                if (!iConduit.hasConnections()) continue;
                ArrayList<CollidableComponent> arrayList3 = new ArrayList<CollidableComponent>();
                this.addConduitCores(arrayList3, iConduit);
                if (arrayList3.size() <= 1) continue;
                BoundingBox boundingBox = ((CollidableComponent)arrayList3.get((int)0)).bound;
                double area = boundingBox.getArea();
                for (CollidableComponent cc2 : arrayList3) {
                    BoundingBox boundingBox2 = var8_49.expandBy(cc2.bound);
                }
                if (!(var8_49.getArea() > area * 1.5)) continue;
                BoundingBox boundingBox3 = var8_49.scale(1.05, 1.05, 1.05);
                CollidableComponent cc3 = new CollidableComponent(null, boundingBox3, null, (Object)ConduitConnectorType.INTERNAL);
                this.cachedConnectors.add(cc3);
            }
            Object var5_12 = null;
            boolean bl = false;
            while (var6_27 < this.cachedConnectors.size()) {
                CollidableComponent collidableComponent = this.cachedConnectors.get((int)var6_27);
                if (collidableComponent.conduitType == null && collidableComponent.data == ConduitConnectorType.INTERNAL) {
                    BoundingBox boundingBox = var5_13 == null ? collidableComponent.bound : var5_13.expandBy(collidableComponent.bound);
                    this.cachedConnectors.remove((int)var6_27);
                    --var6_27;
                }
                ++var6_27;
            }
            if (var5_13 != null) {
                CollidableComponent collidableComponent = new CollidableComponent(null, (BoundingBox)var5_13, null, (Object)ConduitConnectorType.INTERNAL);
                this.cachedConnectors.add(collidableComponent);
            }
            EnumSet<EnumFacing> enumSet = EnumSet.noneOf(EnumFacing.class);
            for (IConduit iConduit : this.getConduits()) {
                Set<EnumFacing> extCons = iConduit.getExternalConnections();
                for (EnumFacing dir : extCons) {
                    if (iConduit.getConnectionMode((EnumFacing)NullHelper.notnull((Object)dir, (String)"IConduit#getExternalConnections#iterator#next")) == ConnectionMode.DISABLED) continue;
                    enumSet.add(dir);
                }
            }
            for (EnumFacing enumFacing : enumSet) {
                if (enumFacing == null) continue;
                BoundingBox bb = ConduitGeometryUtil.getInstance().getExternalConnectorBoundingBox(enumFacing);
                CollidableComponent cc5 = new CollidableComponent(null, bb, enumFacing, (Object)ConduitConnectorType.EXTERNAL);
                this.cachedConnectors.add(cc5);
            }
            this.connectorsDirty = false;
        }
        result.addAll(this.cachedConnectors);
    }

    private void addConduitCores(List<CollidableComponent> result, IConduit con) {
        CollidableCache cc = CollidableCache.instance;
        Class<? extends IConduit> type = con.getCollidableType();
        LinkedHashSet<CollidableComponent> components = new LinkedHashSet<CollidableComponent>();
        if (con.hasConnections()) {
            for (EnumFacing dir : con.getExternalConnections()) {
                components.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), dir), null), con));
            }
            for (EnumFacing dir : con.getConduitConnections()) {
                components.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), dir), null), con));
            }
        } else {
            components.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(con.getBaseConduitType(), null), null), con));
        }
        result.addAll(components);
    }

    private int getConnectionCount(@Nullable EnumFacing dir) {
        if (dir == null) {
            return this.getConduits().size();
        }
        int result = 0;
        for (IConduit iConduit : this.getConduits()) {
            if (!iConduit.containsConduitConnection(dir) && !iConduit.containsExternalConnection(dir)) continue;
            ++result;
        }
        return result;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY || capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY) {
            for (IConduit iConduit : this.getConduits()) {
                if (!iConduit.hasInternalCapability(capability, facing)) continue;
                return iConduit.getInternalCapability(capability, facing);
            }
        }
        if (facing != null) {
            for (IServerConduit iServerConduit : this.getServerConduits()) {
                if (!iServerConduit.hasCapability(capability, facing)) continue;
                return iServerConduit.getCapability(capability, facing);
            }
            if (this.field_145850_b.field_72995_K) {
                for (IClientConduit iClientConduit : this.getClientConduits()) {
                    if (!iClientConduit.hasClientCapability(capability, facing)) continue;
                    return iClientConduit.getClientCapability(capability, facing);
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (IConduit iConduit : this.getServerConduits()) {
            ((IServerConduit)iConduit).invalidate();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(IBlockStateWrapper wrapper, BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        hashCodes.add(this.facadeType.ordinal() << 16 | this.getFacadeRenderedAs().ordinal() << 8 | wrapper.getYetaDisplayMode().getDisplayMode().ordinal() << 1 | (wrapper.getYetaDisplayMode().isHideFacades() ? 1 : 0));
        TileConduitBundle.makeConduitHashCode(this.getClientConduits(), hashCodes);
    }

    @SideOnly(value=Side.CLIENT)
    private static void makeConduitHashCode(Collection<? extends IClientConduit> conduits, BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        for (IConduit iConduit : conduits) {
            if (iConduit instanceof IConduitComponent) {
                ((IConduitComponent)((Object)iConduit)).hashCodeForModelCaching(hashCodes);
                continue;
            }
            hashCodes.add(iConduit);
        }
    }

    public String toString() {
        return !this.func_145830_o() ? super.toString() : (this.field_145850_b.field_72995_K ? TileConduitBundle.toStringC(this) : TileConduitBundle.toStringS(this));
    }

    @SideOnly(value=Side.CLIENT)
    public static String toStringC(TileConduitBundle self) {
        BlockStateWrapperConduitBundle bsw = new BlockStateWrapperConduitBundle(self.field_145850_b.func_180495_p(self.field_174879_c), (IBlockAccess)self.field_145850_b, self.field_174879_c, ConduitRenderMapper.instance);
        bsw.addCacheKey(self);
        return "CLIENT: TileConduitBundle [pos=" + self.field_174879_c + ", facade=" + self.getPaintSource() + ", facadeType=" + (Object)((Object)self.facadeType) + ", conduits=" + self.getClientConduits() + ", cachekey=" + bsw.getCachekey() + ", bsw=" + bsw + "]";
    }

    public static String toStringS(TileConduitBundle self) {
        return "SERVER: TileConduitBundle [pos=" + self.field_174879_c + ", conduits=" + self.getServerConduits() + "]";
    }

    @Override
    public void setFilter(int filterIndex, int param, @Nonnull IFilter filter) {
        for (IConduit iConduit : this.getConduits()) {
            IFilterHolder filterHolder;
            if (!iConduit.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, EnumFacing.func_82600_a((int)param)) || (filterHolder = iConduit.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, EnumFacing.func_82600_a((int)param))) == null || filterHolder.getInputFilterIndex() != filterIndex && filterHolder.getOutputFilterIndex() != filterIndex) continue;
            filterHolder.setFilter(filterIndex, param, filter);
        }
    }

    @Override
    public IFilter getFilter(int filterIndex, int param) {
        for (IConduit iConduit : this.getConduits()) {
            IFilterHolder filterHolder;
            if (!iConduit.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, EnumFacing.func_82600_a((int)param)) || (filterHolder = iConduit.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, EnumFacing.func_82600_a((int)param))) == null || filterHolder.getInputFilterIndex() != filterIndex && filterHolder.getOutputFilterIndex() != filterIndex) continue;
            return filterHolder.getFilter(filterIndex, param);
        }
        return null;
    }

    @Override
    @Nullable
    public IItemHandler getInventoryForSnapshot(int filterIndex, int param) {
        for (IConduit iConduit : this.getConduits()) {
            IFilterHolder filterHolder;
            if (!iConduit.hasInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, EnumFacing.func_82600_a((int)param)) || (filterHolder = iConduit.getInternalCapability(CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY, EnumFacing.func_82600_a((int)param))) == null || filterHolder.getInputFilterIndex() != filterIndex && filterHolder.getOutputFilterIndex() != filterIndex) continue;
            return filterHolder.getInventoryForSnapshot(filterIndex, param);
        }
        return null;
    }

    @Override
    @Nonnull
    public Set<? extends ILocalizable> getNotification() {
        HashSet<? extends ILocalizable> result = new HashSet<ILocalizable>();
        for (IServerConduit conduit : this.getServerConduits()) {
            if (!(conduit instanceof INotifier)) continue;
            result.addAll(((INotifier)((Object)conduit)).getNotification());
        }
        return result;
    }
}

