/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.render.model;

import com.google.common.collect.Lists;
import crazypants.enderio.base.EnderIO;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class RotatingSmartItemModel
implements IBakedModel {
    @Nonnull
    private final IBakedModel parent;
    private final int speed;
    @Nonnull
    private final ItemOverrideList overrides = new ItemOverrideList(Lists.newArrayList()){

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            if (originalModel != RotatingSmartItemModel.this) {
                return originalModel;
            }
            IBakedModel newBase = RotatingSmartItemModel.this.parent.func_188617_f().handleItemState(RotatingSmartItemModel.this.parent, stack, world, entity);
            if (RotatingSmartItemModel.this.parent != newBase) {
                return new RotatingSmartItemModel(newBase, RotatingSmartItemModel.this.speed);
            }
            return RotatingSmartItemModel.this;
        }
    };

    public RotatingSmartItemModel(@Nonnull IBakedModel parent, int speed) {
        this.parent = parent;
        this.speed = speed;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.parent.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
        Pair perspective = this.parent.handlePerspective(cameraTransformType);
        double r = (float)(EnderIO.proxy.getTickCount() % 360L) + Minecraft.func_71410_x().func_184121_ak();
        TRSRTransformation transformOrig = new TRSRTransformation((Matrix4f)perspective.getRight());
        Quat4f leftRot = transformOrig.getLeftRot();
        Quat4f yRotation = new Quat4f();
        yRotation.set(new AxisAngle4d(0.0, 1.0, 0.0, Math.toRadians(r * (double)this.speed)));
        leftRot.mul(yRotation);
        TRSRTransformation transformNew = new TRSRTransformation(transformOrig.getTranslation(), leftRot, transformOrig.getScale(), transformOrig.getRightRot());
        return Pair.of((Object)perspective.getLeft(), (Object)transformNew.getMatrix());
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }
}

