/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe.tank;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.xp.XpUtil;
import crazypants.enderio.util.Prep;
import info.loenwind.autoconfig.util.NullHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TankMachineRecipe
implements IMachineRecipe {
    @Nonnull
    public static final FluidStack NOTHING = new FluidStack(FluidRegistry.WATER, 0);
    @Nonnull
    private final String recipeName;
    private final boolean isFilling;
    @Nonnull
    private final Things input;
    @Nonnull
    private final FluidStack fluid;
    @Nonnull
    private final Things output;
    @Nonnull
    private final Logic logic;
    @Nonnull
    private final RecipeLevel recipelevel;

    @Nullable
    public RecipeResult executeRecipe(@Nonnull ItemStack machineInput, @Nonnull FluidStack machineFluid) {
        RecipeResult result = new RecipeResult();
        result.itemResult = this.logic.convertItemResult(this.isFilling, machineInput, machineFluid, this.fluid, this.output.getItemStack());
        FluidStack fluidResult = this.logic.convertFluidResult(this.isFilling, machineInput, machineFluid, this.fluid, this.output.getItemStack());
        result.remainingInputItem = machineInput.func_77946_l();
        result.consumedInputItem = result.remainingInputItem.func_77979_a(this.input.getItemStack().func_190916_E());
        if (this.isFilling) {
            result.remainingInputFluid = machineFluid.copy();
            result.remainingInputFluid.amount -= fluidResult.amount;
            if (result.remainingInputFluid.amount < 0) {
                return null;
            }
            result.consumedInputFluid = machineFluid.copy();
            result.consumedInputFluid.amount = fluidResult.amount;
        } else if (machineFluid.amount == 0) {
            result.remainingInputFluid = fluidResult;
            result.consumedInputFluid = machineFluid;
        } else {
            result.remainingInputFluid = machineFluid.copy();
            result.remainingInputFluid.amount += fluidResult.amount;
            result.consumedInputFluid = machineFluid.copy();
            result.consumedInputFluid.amount = 0;
        }
        return result;
    }

    public TankMachineRecipe(@Nonnull String recipeName, boolean isFilling, @Nonnull Things input, @Nonnull FluidStack fluid, Things output, @Nonnull Logic logic, @Nonnull RecipeLevel recipelevel) {
        this.recipeName = recipeName;
        this.isFilling = isFilling;
        this.input = input;
        this.fluid = fluid;
        this.output = output != null ? output : new Things();
        this.logic = logic;
        this.recipelevel = recipelevel;
    }

    @Override
    @Nonnull
    public String getUid() {
        return this.recipeName;
    }

    @Override
    public int getEnergyRequired(@Nonnull NNList<MachineRecipeInput> inputs) {
        return 0;
    }

    @Override
    public boolean isRecipe(@Nonnull RecipeLevel machineLevel, @Nonnull NNList<MachineRecipeInput> inputs) {
        if (!machineLevel.canMake(this.recipelevel)) {
            return false;
        }
        if (inputs.size() != 2) {
            return false;
        }
        ItemStack machineItemStack = this.getInputItem(inputs);
        if (Prep.isInvalid(machineItemStack)) {
            return false;
        }
        if (!this.input.contains(machineItemStack)) {
            return false;
        }
        FluidStack machineFluid = this.getInputFluid(inputs);
        if (this.isFilling && machineFluid.amount == 0) {
            return false;
        }
        return machineFluid.amount == 0 || machineFluid.containsFluid(this.fluid);
    }

    @Nonnull
    private ItemStack getInputItem(@Nonnull NNList<MachineRecipeInput> inputs) {
        for (MachineRecipeInput machineRecipeInput : inputs) {
            if (machineRecipeInput.isFluid()) continue;
            return machineRecipeInput.item;
        }
        return Prep.getEmpty();
    }

    @Nonnull
    private FluidStack getInputFluid(@Nonnull NNList<MachineRecipeInput> inputs) {
        for (MachineRecipeInput machineRecipeInput : inputs) {
            if (!machineRecipeInput.isFluid()) continue;
            return (FluidStack)NullHelper.first((Object[])new FluidStack[]{machineRecipeInput.fluid, NOTHING});
        }
        return NOTHING;
    }

    @Override
    @Nonnull
    public IMachineRecipe.ResultStack[] getCompletedResult(long nextSeed, float chanceMultiplier, @Nonnull NNList<MachineRecipeInput> inputs) {
        RecipeResult recipeResult = this.executeRecipe(this.getInputItem(inputs), this.getInputFluid(inputs));
        if (recipeResult != null) {
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(recipeResult.itemResult), new IMachineRecipe.ResultStack(recipeResult.remainingInputFluid)};
        }
        return new IMachineRecipe.ResultStack[0];
    }

    @Override
    public boolean isValidInput(@Nonnull RecipeLevel machineLevel, @Nonnull MachineRecipeInput machineInput) {
        if (machineInput.isFluid()) {
            return machineInput.fluid.containsFluid(this.fluid);
        }
        return this.input.contains(machineInput.item);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return this.isFilling ? "tankfill" : "tankempty";
    }

    @Override
    @Nonnull
    public List<MachineRecipeInput> getQuantitiesConsumed(@Nonnull NNList<MachineRecipeInput> inputs) {
        RecipeResult recipeResult = this.executeRecipe(this.getInputItem(inputs), this.getInputFluid(inputs));
        if (recipeResult == null) {
            return NNList.emptyList();
        }
        ArrayList<MachineRecipeInput> result = new ArrayList<MachineRecipeInput>();
        for (MachineRecipeInput machineRecipeInput : inputs) {
            if (machineRecipeInput.isFluid()) {
                result.add(new MachineRecipeInput(machineRecipeInput.slotNumber, recipeResult.consumedInputFluid));
                continue;
            }
            result.add(new MachineRecipeInput(machineRecipeInput.slotNumber, recipeResult.getConsumedInputItem()));
        }
        return result;
    }

    @Nonnull
    public Logic getLogic() {
        return this.logic;
    }

    @Nonnull
    public String getRecipeName() {
        return this.recipeName;
    }

    public boolean isFilling() {
        return this.isFilling;
    }

    @Nonnull
    public Things getInput() {
        return this.input;
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Nonnull
    public Things getOutput() {
        return this.output;
    }

    @Nonnull
    public RecipeLevel getRecipelevel() {
        return this.recipelevel;
    }

    public class RecipeResult {
        @Nonnull
        ItemStack consumedInputItem = Prep.getEmpty();
        @Nonnull
        ItemStack remainingInputItem = Prep.getEmpty();
        @Nonnull
        ItemStack itemResult = Prep.getEmpty();
        @Nonnull
        FluidStack consumedInputFluid = NOTHING;
        @Nonnull
        FluidStack remainingInputFluid = NOTHING;

        @Nonnull
        public ItemStack getConsumedInputItem() {
            return this.consumedInputItem;
        }

        @Nonnull
        public ItemStack getRemainingInputItem() {
            return this.remainingInputItem;
        }

        @Nonnull
        public ItemStack getItemResult() {
            return this.itemResult;
        }

        @Nonnull
        public FluidStack getConsumedInputFluid() {
            return this.consumedInputFluid;
        }

        @Nonnull
        public FluidStack getRemainingInputFluid() {
            return this.remainingInputFluid;
        }
    }

    public static enum Logic {
        NONE,
        XPBOTTLE{

            @Override
            @Nonnull
            FluidStack convertFluidResult(boolean isFilling, @Nonnull ItemStack input, @Nonnull FluidStack machineFluid, @Nonnull FluidStack recipeFluid, @Nonnull ItemStack output) {
                FluidStack copy = recipeFluid.copy();
                copy.amount *= XpUtil.experienceToLiquid(3 + rand.nextInt(5) + rand.nextInt(5));
                return copy;
            }

            @Override
            public void executeSFX(boolean isFilling, @Nonnull World world, @Nonnull BlockPos pos) {
                if (!isFilling) {
                    BlockPos eventPos = pos;
                    if (world.field_73012_v.nextBoolean()) {
                        eventPos = eventPos.func_177968_d();
                    }
                    if (world.field_73012_v.nextBoolean()) {
                        eventPos = eventPos.func_177974_f();
                    }
                    world.func_175718_b(2002, eventPos, PotionUtils.func_185183_a((PotionType)PotionTypes.field_185230_b));
                }
            }
        }
        ,
        XP{

            @Override
            @Nonnull
            FluidStack convertFluidResult(boolean isFilling, @Nonnull ItemStack input, @Nonnull FluidStack machineFluid, @Nonnull FluidStack recipeFluid, @Nonnull ItemStack output) {
                FluidStack copy = recipeFluid.copy();
                copy.amount = XpUtil.experienceToLiquid(copy.amount);
                return copy;
            }
        };

        @Nonnull
        private static final Random rand;

        @Nonnull
        ItemStack convertItemResult(boolean isFilling, @Nonnull ItemStack input, @Nonnull FluidStack machineFluid, @Nonnull FluidStack recipeFluid, @Nonnull ItemStack output) {
            return output.func_77946_l();
        }

        @Nonnull
        FluidStack convertFluidResult(boolean isFilling, @Nonnull ItemStack input, @Nonnull FluidStack machineFluid, @Nonnull FluidStack recipeFluid, @Nonnull ItemStack output) {
            return recipeFluid.copy();
        }

        public void executeSFX(boolean isFilling, @Nonnull World world, @Nonnull BlockPos pos) {
        }

        static {
            rand = new Random();
        }
    }
}

