/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.soulvial;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.interfaces.IOverlayRenderAware;
import com.enderio.core.common.util.DyeColor;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.recipe.spawner.EntityDataRegistry;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.base.render.itemoverlay.MobNameOverlayRenderHelper;
import crazypants.enderio.util.CapturedMob;
import crazypants.enderio.util.Prep;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.TargetContext;

public class ItemSoulVial
extends Item
implements IResourceTooltipProvider,
IHaveRenderers,
IOverlayRenderAware,
IModObject.LifecycleInit {
    @Nonnull
    public final IBehaviorDispenseItem DISPENSER_BEHAVIOR = new BehaviorDefaultDispenseItem(){

        @Nonnull
        protected ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
            EnumFacing enumfacing;
            ItemStack secondaryResult;
            block6: {
                CapturedMob capturedMob;
                block5: {
                    secondaryResult = Prep.getEmpty();
                    enumfacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                    capturedMob = CapturedMob.create(stack);
                    if (capturedMob == null) break block5;
                    if (!capturedMob.spawn(source.func_82618_k(), source.func_180699_d().func_177972_a(enumfacing).func_177977_b(), EnumFacing.UP, true)) break block6;
                    stack.func_190918_g(1);
                    secondaryResult = new ItemStack((Item)ItemSoulVial.this);
                    break block6;
                }
                for (EntityLivingBase entity : source.func_82618_k().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(source.func_180699_d().func_177972_a(enumfacing)), EntitySelectors.field_180132_d)) {
                    if (entity instanceof IEntityOwnable && ((IEntityOwnable)entity).func_184753_b() != null || (capturedMob = CapturedMob.create((Entity)entity)) == null) continue;
                    entity.func_70106_y();
                    if (!entity.field_70128_L) continue;
                    stack.func_190918_g(1);
                    secondaryResult = capturedMob.toStack(ItemSoulVial.this, 1, 1);
                    break;
                }
            }
            if (Prep.isValid(secondaryResult)) {
                if (Prep.isInvalid(stack)) {
                    stack = secondaryResult;
                } else {
                    TileEntity blockTileEntity = source.func_150835_j();
                    if (!(blockTileEntity instanceof TileEntityDispenser) || ((TileEntityDispenser)blockTileEntity).func_146019_a(secondaryResult) < 0) {
                        Block.func_180635_a((World)source.func_82618_k(), (BlockPos)source.func_180699_d().func_177972_a(enumfacing), (ItemStack)secondaryResult);
                    }
                }
            }
            return stack;
        }
    };
    @Nonnull
    private String permissionPickupOwned = "(item not initialized)";
    @Nonnull
    private String permissionPickup = "(item not initialized)";
    @Nonnull
    private String permissionPlace = "(item not initialized)";

    @Override
    public void init(@Nonnull IModObject modObject, @Nonnull FMLInitializationEvent event) {
        this.permissionPickupOwned = PermissionAPI.registerNode((String)"enderio.soulvial.pickup_owned", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Permission to pickup an entity that is owned by another player with Ender IO's soul vessel");
        this.permissionPickup = PermissionAPI.registerNode((String)"enderio.soulvial.pickup", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Permission to pickup an entity with Ender IO's soul vessel");
        this.permissionPlace = PermissionAPI.registerNode((String)"enderio.soulvial.place", (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Permission to place down an entity with Ender IO's soul vessel");
    }

    public static ItemSoulVial create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemSoulVial(modObject);
    }

    protected ItemSoulVial(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        modObject.apply(this);
        this.func_77625_d(16);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)this.DISPENSER_BEHAVIOR);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(@Nonnull IModObject modObject) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(modObject.getRegistryName(), "variant=empty"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(modObject.getRegistryName(), "variant=full"));
    }

    public int getMetadata(@Nonnull ItemStack stack) {
        if (CapturedMob.containsSoul(stack)) {
            return 1;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack item) {
        return CapturedMob.containsSoul(item);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        CapturedMob capturedMob = CapturedMob.create(itemstack);
        if (capturedMob == null) {
            return EnumActionResult.SUCCESS;
        }
        if (!PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)this.permissionPlace, (IContext)new BlockPosContext(player, pos, null, side))) {
            player.func_145747_a((ITextComponent)Lang.SOUL_VIAL_DENIED.toChatServer());
            return EnumActionResult.SUCCESS;
        }
        if (!capturedMob.spawn(world, pos, side, true)) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
            ItemStack emptyVial = new ItemStack((Item)this);
            if (Prep.isInvalid(itemstack)) {
                player.func_184611_a(hand, emptyVial);
            } else if (!player.field_71071_by.func_70441_a(emptyVial)) {
                player.func_71019_a(emptyVial, false);
            }
            player.field_71069_bz.func_75142_b();
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_111207_a(@Nonnull ItemStack item, @Nonnull EntityPlayer player, @Nonnull EntityLivingBase entity, @Nonnull EnumHand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        if (CapturedMob.containsSoul(item) && !isCreative) {
            return false;
        }
        CapturedMob capturedMob = CapturedMob.create((Entity)entity);
        if (capturedMob == null) {
            if (entity instanceof EntityPlayer) {
                player.func_145747_a((ITextComponent)Lang.SOUL_VIAL_DENIED_PLAYER.toChatServer());
            } else if (CapturedMob.isBlacklisted((Entity)entity)) {
                player.func_145747_a((ITextComponent)Lang.SOUL_VIAL_DENIED_AALISTED.toChatServer());
            }
            return false;
        }
        if (entity instanceof IEntityOwnable && ((IEntityOwnable)entity).func_184753_b() != null && !player.equals((Object)((IEntityOwnable)entity).func_70902_q()) && !PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)this.permissionPickupOwned, (IContext)new TargetContext(player, (Entity)entity))) {
            player.func_145747_a((ITextComponent)Lang.SOUL_VIAL_DENIED_OWNED_PET.toChatServer());
            return false;
        }
        if (!PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)this.permissionPickup, (IContext)new TargetContext(player, (Entity)entity))) {
            player.func_145747_a((ITextComponent)Lang.SOUL_VIAL_DENIED.toChatServer());
            return false;
        }
        ItemStack capturedMobVessel = capturedMob.toStack(this, 1, 1);
        player.func_184609_a(hand);
        if (!isCreative) {
            entity.func_70106_y();
            if (entity.field_70128_L) {
                if (item.func_190916_E() > 1) {
                    item.func_190918_g(1);
                    if (!player.field_71071_by.func_70441_a(capturedMobVessel)) {
                        player.func_71019_a(capturedMobVessel, false);
                    }
                } else {
                    player.func_184611_a(hand, capturedMobVessel);
                }
                player.field_71069_bz.func_75142_b();
                return true;
            }
        } else {
            if (!player.field_71071_by.func_70441_a(capturedMobVessel)) {
                player.func_71019_a(capturedMobVessel, false);
            }
            player.field_71069_bz.func_75142_b();
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack createVesselWithEntityStub(ResourceLocation entityId) {
        CapturedMob capturedMob = CapturedMob.create(entityId);
        if (capturedMob == null) {
            return Prep.getEmpty();
        }
        return capturedMob.toStack(this, 1, 1);
    }

    @Nonnull
    public ItemStack createVesselWithEntity(Entity entity) {
        CapturedMob capturedMob = CapturedMob.create(entity);
        if (capturedMob == null) {
            return Prep.getEmpty();
        }
        return capturedMob.toStack(this, 1, 1);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (tab == this.func_77640_w()) {
            super.func_150895_a(tab, list);
        } else if (tab == EnderIOTab.tabEnderIOMobs) {
            for (CapturedMob capturedMob : CapturedMob.getAllSouls()) {
                if (EntityDataRegistry.getInstance().isBlackListedForSoulVial(capturedMob.getEntityName())) continue;
                list.add((Object)capturedMob.toStack(this, 1, 1));
            }
        }
    }

    @Nonnull
    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{this.func_77640_w(), EnderIOTab.tabEnderIOMobs};
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.func_77667_c(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CapturedMob capturedMob = CapturedMob.create(stack);
        if (capturedMob != null) {
            DyeColor color;
            Fluid fluid;
            String fluidName;
            tooltip.add(capturedMob.getDisplayName());
            float health = capturedMob.getHealth();
            if (health >= 0.0f) {
                float maxHealth = capturedMob.getMaxHealth();
                if (maxHealth >= 0.0f) {
                    tooltip.add(Lang.SOUL_VIAL_HEALTH.get(String.format("%3.1f/%3.1f", Float.valueOf(health), Float.valueOf(maxHealth))));
                } else {
                    tooltip.add(Lang.SOUL_VIAL_HEALTH.get(String.format("%3.1f", Float.valueOf(health))));
                }
            }
            if ((fluidName = capturedMob.getFluidName()) != null && (fluid = FluidRegistry.getFluid((String)fluidName)) != null) {
                String localizedName = fluid.getLocalizedName(new FluidStack(fluid, 1));
                tooltip.add(Lang.SOUL_VIAL_FLUID.get(localizedName));
            }
            if ((color = capturedMob.getColor()) != null) {
                tooltip.add(Lang.SOUL_VIAL_COLOR.get(color.getLocalisedName()));
            }
        } else {
            tooltip.add(Lang.SOUL_VIAL_EMPTY.get());
        }
    }

    public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        MobNameOverlayRenderHelper.doItemOverlayIntoGUI(stack, xPosition, yPosition);
    }
}

