/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.darksteel.upgrade.storage;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class StorageCap
extends ItemStackHandler {
    @Nonnull
    private final EntityEquipmentSlot equipmentSlot;
    @Nonnull
    private final ItemStack owner;
    private final EntityPlayer player;

    public StorageCap(@Nonnull EntityEquipmentSlot equipmentSlot, int size, @Nonnull EntityPlayer player) {
        super(size);
        this.equipmentSlot = equipmentSlot;
        this.player = size > 0 ? player : null;
        this.owner = size > 0 ? (ItemStack)player.field_71071_by.field_70460_b.get(equipmentSlot.func_188454_b()) : Prep.getEmpty();
        size = Prep.isValid(this.owner) ? size : 0;
        this.deserializeNBT(NbtValue.INVENTORY.getTag(this.owner));
        if (size != super.getSlots()) {
            if (size < super.getSlots()) {
                Iterator itr = this.stacks.iterator();
                while (itr.hasNext()) {
                    ItemStack next = (ItemStack)itr.next();
                    if (next != null && !Prep.isInvalid(next)) continue;
                    itr.remove();
                }
            }
            while (size < super.getSlots()) {
                player.func_71019_a((ItemStack)this.stacks.remove(this.stacks.size() - 1), true);
            }
            while (size > super.getSlots()) {
                this.stacks.add((Object)Prep.getEmpty());
            }
            this.onContentsChanged(0);
        }
    }

    public StorageCap(@Nonnull EntityEquipmentSlot equipmentSlot, int size) {
        super(size);
        this.equipmentSlot = equipmentSlot;
        this.owner = Prep.getEmpty();
        this.player = null;
    }

    public boolean isStillConnectedToPlayer() {
        return this.player == null || Prep.isInvalid(this.owner) || this.owner == this.player.field_71071_by.field_70460_b.get(this.equipmentSlot.func_188454_b());
    }

    @Nonnull
    public EntityEquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack == this.owner || stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) != null || this.isLarge(stack)) {
            return ItemStack.field_190927_a;
        }
        return super.insertItem(slot, stack, simulate);
    }

    private boolean isLarge(@Nonnull ItemStack stack) {
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)stack);
        boolean result = buffer.writerIndex() <= 500;
        buffer.release();
        return result;
    }

    protected void onContentsChanged(int slot) {
        NbtValue.INVENTORY.setTag(this.owner, this.serializeNBT());
    }

    public void setSize(int size) {
        this.stacks = new NNList(size, (Object)Prep.getEmpty());
    }
}

