/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base;

import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.autosave.BaseHandlers;
import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.util.HandlePaintSource;
import crazypants.enderio.util.NbtValue;
import info.loenwind.autosave.Reader;
import info.loenwind.autosave.Registry;
import info.loenwind.autosave.Writer;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.util.NBTAction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Storable
@Mod.EventBusSubscriber(modid="enderio")
public abstract class TileEntityEio
extends TileEntityBase {
    @Nonnull
    private static final Vector4f COLOR_UPD = new Vector4f(1.0f, 0.7137255f, 0.0f, 0.2f);
    @Nonnull
    private static final Vector4f COLOR_REN = new Vector4f(0.38039216f, 0.1764706f, 0.70980394f, 0.4f);
    @Nonnull
    private static final Vector4f COLOR_REN_SRV = new Vector4f(0.0f, 0.42745098f, 0.56078434f, 0.8f);
    @Store(value={NBTAction.CLIENT})
    private boolean forceClientRerender = false;
    @Store(value={NBTAction.CLIENT, NBTAction.SAVE}, handler=HandlePaintSource.class)
    private IBlockState paintSource = null;
    private static final NNList<TileEntity> notTickingTileEntitiesS = new NNList();
    private static final NNList<TileEntity> notTickingTileEntitiesC = new NNList();

    protected TileEntityEio() {
        if (((Boolean)DiagnosticsConfig.debugTraceTELivecycleExtremelyDetailed.get()).booleanValue()) {
            StringBuilder sb = new StringBuilder("TE ").append((Object)this).append(" created");
            for (StackTraceElement elem : new Exception("Stacktrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (((Boolean)DiagnosticsConfig.debugTraceTELivecycleExtremelyDetailed.get()).booleanValue()) {
            StringBuilder sb = new StringBuilder("TE ").append((Object)this).append(" invalidated");
            for (StackTraceElement elem : new Exception("Stacktrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (((Boolean)DiagnosticsConfig.debugTraceTELivecycleExtremelyDetailed.get()).booleanValue()) {
            StringBuilder sb = new StringBuilder("TE ").append((Object)this).append(" unloaded");
            for (StackTraceElement elem : new Exception("Stacktrace").getStackTrace()) {
                sb.append(" at ").append(elem);
            }
            Log.warn(sb);
        }
    }

    @Deprecated
    @Nonnull
    private NBTAction convertAction(com.enderio.core.common.NBTAction action) {
        return (NBTAction)NullHelper.notnullJ((Object)NBTAction.values()[action.ordinal()], (String)"Enum.values()");
    }

    @Deprecated
    protected void readCustomNBT(@Nonnull com.enderio.core.common.NBTAction action, @Nonnull NBTTagCompound root) {
        this.readCustomNBT(this.convertAction(action), root);
    }

    @Deprecated
    protected void writeCustomNBT(@Nonnull com.enderio.core.common.NBTAction action, @Nonnull NBTTagCompound root) {
        this.writeCustomNBT(this.convertAction(action), root);
    }

    protected final void writeCustomNBT(@Nonnull NBTAction action, @Nonnull NBTTagCompound root) {
        this.onBeforeNbtWrite();
        Writer.write((Registry)BaseHandlers.REGISTRY, (NBTAction)action, (NBTTagCompound)root, (Object)((Object)this));
    }

    protected final void readCustomNBT(@Nonnull NBTAction action, @Nonnull NBTTagCompound root) {
        Reader.read((Registry)BaseHandlers.REGISTRY, (NBTAction)action, (NBTTagCompound)root, (Object)((Object)this));
        if (action == NBTAction.CLIENT) {
            this.onAfterDataPacket();
        }
        this.onAfterNbtRead();
    }

    protected void onAfterDataPacket() {
        if (this.forceClientRerender) {
            super.updateBlock();
            this.forceClientRerender = false;
            if (((Boolean)DiagnosticsConfig.debugChunkRerenders.get()).booleanValue()) {
                EnderIO.proxy.markBlock(this.func_145831_w(), this.func_174877_v(), COLOR_REN_SRV);
            }
        } else if (((Boolean)DiagnosticsConfig.debugUpdatePackets.get()).booleanValue()) {
            EnderIO.proxy.markBlock(this.func_145831_w(), this.func_174877_v(), COLOR_UPD);
        }
    }

    protected void updateBlock() {
        super.updateBlock();
        if (!this.field_145850_b.field_72995_K) {
            this.forceClientRerender = true;
            this.forceUpdatePlayers();
            this.forceClientRerender = false;
        } else if (((Boolean)DiagnosticsConfig.debugChunkRerenders.get()).booleanValue()) {
            EnderIO.proxy.markBlock(this.func_145831_w(), this.func_174877_v(), COLOR_REN);
        }
    }

    protected void onBeforeNbtWrite() {
    }

    protected void onAfterNbtRead() {
    }

    public void readCustomNBT(@Nonnull ItemStack stack) {
        if (NbtValue.DATAROOT.hasTag(stack)) {
            NBTTagCompound tagCompound = NbtValue.DATAROOT.getTag(stack);
            this.readCustomNBT(NBTAction.ITEM, tagCompound);
        }
        this.setPaintSource(PaintUtil.getSourceBlock(stack));
    }

    public void writeCustomNBT(@Nonnull ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(NBTAction.ITEM, tag);
        if (!tag.func_82582_d()) {
            NbtValue.DATAROOT.setTag(stack, tag);
        }
        PaintUtil.setSourceBlock(stack, this.getPaintSource());
    }

    @Nonnull
    protected ItemStack processPickBlock(@Nonnull RayTraceResult target, @Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
        PaintUtil.setSourceBlock(stack, this.getPaintSource());
        return stack;
    }

    public void setPaintSource(@Nullable IBlockState paintSource) {
        if (this.paintSource != paintSource) {
            this.paintSource = paintSource;
            this.func_70296_d();
            this.updateBlock();
        }
    }

    public IBlockState getPaintSource() {
        return this.paintSource;
    }

    protected void doUpdate() {
        this.disableTicking();
    }

    protected void disableTicking() {
        if (this.field_145850_b.field_72995_K) {
            notTickingTileEntitiesC.add((Object)this);
        } else {
            notTickingTileEntitiesS.add((Object)this);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        for (TileEntity te : notTickingTileEntitiesS) {
            te.func_145831_w().field_175730_i.remove(te);
        }
        notTickingTileEntitiesS.clear();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        for (TileEntity te : notTickingTileEntitiesC) {
            te.func_145831_w().field_175730_i.remove(te);
        }
        notTickingTileEntitiesC.clear();
    }

    public final boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing1) {
        return this.getCapability(capability, facing1) != null;
    }
}

