/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.api;

import com.enderio.core.common.util.stackable.IProducer;
import crazypants.enderio.api.IModTileEntity;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IModObject
extends IProducer,
IForgeRegistryEntry<IModObject> {
    @Nonnull
    public String getUnlocalisedName();

    @Nonnull
    public ResourceLocation getRegistryName();

    @Nonnull
    public <B extends Block> B apply(@Nonnull B var1);

    @Nonnull
    public <I extends Item> I apply(@Nonnull I var1);

    @Nullable
    public Class<? extends TileEntity> getTEClass();

    @Deprecated
    @Nullable
    public Class<?> getClazz();

    @Deprecated
    @Nullable
    public String getBlockMethodName();

    @Deprecated
    @Nullable
    public String getItemMethodName();

    @Nonnull
    default public Function<IModObject, Block> getBlockCreator() {
        return modobject -> {
            Class<?> clazz = modobject.getClazz();
            try {
                if (modobject.getBlockMethodName() == null || clazz == null) {
                    return null;
                }
                return (Block)clazz.getDeclaredMethod(modobject.getBlockMethodName(), IModObject.class).invoke(null, modobject);
            }
            catch (Error | Exception e) {
                throw new RuntimeException("ModObject:create: Could not create instance for " + clazz + " using method " + modobject.getBlockMethodName(), e);
            }
        };
    }

    @Nonnull
    default public BiFunction<IModObject, Block, Item> getItemCreator() {
        return (modobject, block) -> {
            if (modobject == null) {
                throw new NullPointerException();
            }
            Class<?> clazz = modobject.getClazz();
            if (modobject.getItemMethodName() == null || clazz == null) {
                return WithBlockItem.itemCreator.apply((IModObject)modobject, (Block)block);
            }
            try {
                return (Item)clazz.getDeclaredMethod(modobject.getItemMethodName(), IModObject.class, Block.class).invoke(null, modobject, block);
            }
            catch (Error | Exception e0) {
                try {
                    return (Item)clazz.getDeclaredMethod(modobject.getItemMethodName(), IModObject.class).invoke(null, modobject);
                }
                catch (Error | Exception e) {
                    throw new RuntimeException("ModObject:create: Could not create instance for " + clazz + " using method " + modobject.getItemMethodName(), e);
                }
            }
        };
    }

    @Nullable
    public IModTileEntity getTileEntity();

    public void setItem(@Nullable Item var1);

    public void setBlock(@Nullable Block var1);

    public boolean openGui(@Nonnull World var1, @Nonnull BlockPos var2, @Nonnull EntityPlayer var3);

    public boolean openGui(@Nonnull World var1, @Nonnull BlockPos var2, @Nonnull EntityPlayer var3, @Nullable EnumFacing var4);

    public boolean openGui(@Nonnull World var1, @Nonnull BlockPos var2, @Nonnull EntityPlayer var3, @Nullable EnumFacing var4, int var5);

    public boolean openGui(@Nonnull World var1, @Nonnull EntityPlayer var2, int var3, int var4, int var5);

    public boolean openClientGui(@Nonnull World var1, @Nonnull BlockPos var2, @Nonnull EntityPlayer var3, @Nullable EnumFacing var4, int var5);

    public boolean openClientGui(@Nonnull World var1, @Nonnull EntityPlayer var2, int var3, int var4, int var5);

    public static interface LifecyclePostInit {
        public void init(@Nonnull IModObject var1, @Nonnull FMLPostInitializationEvent var2);
    }

    public static interface LifecycleInit {
        public void init(@Nonnull IModObject var1, @Nonnull FMLInitializationEvent var2);
    }

    public static interface WithBlockItem {
        @Nonnull
        public static final BiFunction<IModObject, Block, Item> itemCreator = (modobject, block) -> {
            if (modobject == null) {
                throw new NullPointerException();
            }
            if (block instanceof WithBlockItem) {
                return ((WithBlockItem)block).createBlockItem((IModObject)modobject);
            }
            return null;
        };

        @Nullable
        default public Item createBlockItem(@Nonnull IModObject modObject) {
            return modObject.apply(new ItemBlock((Block)this));
        }
    }
}

