/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.gui;

import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiMessageDialog;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiConfigBase
extends GuiConfig {
    public GuiConfigBase(GuiScreen parentScreen, List<IConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title) {
        super(parentScreen, configElements, modID, allRequireWorldRestart, allRequireMcRestart, title);
    }

    protected void doFixups() {
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 2000) {
            boolean flag = true;
            try {
                if ((this.configID != null || this.parentScreen == null || !(this.parentScreen instanceof GuiConfig)) && this.entryList.hasChangedEntry(true)) {
                    boolean requiresMcRestart = this.entryList.saveConfigElements();
                    this.doFixups();
                    if (Loader.isModLoaded((String)this.modID)) {
                        ConfigChangedEvent.OnConfigChangedEvent event = new ConfigChangedEvent.OnConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.getResult().equals((Object)Event.Result.DENY)) {
                            MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent.PostConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart));
                        }
                        if (requiresMcRestart) {
                            flag = false;
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiMessageDialog(this.parentScreen, "fml.configgui.gameRestartTitle", (ITextComponent)new TextComponentString(I18n.func_135052_a((String)"fml.configgui.gameRestartRequired", (Object[])new Object[0])), "fml.configgui.confirmRestartMessage"));
                        }
                        if (this.parentScreen instanceof GuiConfig) {
                            ((GuiConfig)this.parentScreen).needsRefresh = true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                FMLLog.log.error("Error performing GuiConfig action:", e);
            }
            if (flag) {
                this.field_146297_k.func_147108_a(this.parentScreen);
            }
        } else if (button.field_146127_k == 2001) {
            this.entryList.setAllToDefault(this.chkApplyGlobally.isChecked());
        } else if (button.field_146127_k == 2002) {
            this.entryList.undoAllChanges(this.chkApplyGlobally.isChecked());
        }
    }
}

