/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.elem.GuiElementSlotMover;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.InventorySlotHolder;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.gui.json.JsonGuiInfo;
import buildcraft.lib.gui.pos.IGuiPosition;
import com.google.gson.JsonSyntaxException;
import net.minecraft.inventory.Slot;

public class ElementTypeSlot
extends ElementType {
    public static final String NAME = "buildcraftlib:slot";
    public static final ElementTypeSlot INSTANCE = new ElementTypeSlot();

    public ElementTypeSlot() {
        super(NAME);
    }

    @Override
    protected IGuiElement deserialize0(BuildCraftJsonGui gui, IGuiPosition parent, JsonGuiInfo info, JsonGuiElement json) {
        FunctionContext ctx = ElementTypeSlot.createContext(json);
        String slotName = json.properties.get("slot");
        IGuiPosition pos = ElementTypeSlot.resolvePosition(json, "pos", parent, ctx);
        Slot slot = gui.properties.get(slotName, Slot.class);
        IExpressionNode.INodeBoolean visible = ElementTypeSlot.getEquationBool(json, "visible", ctx, true);
        if (slot != null) {
            return new GuiElementSlotMover(gui, pos, visible, slot);
        }
        InventorySlotHolder holder = gui.properties.get(slotName, InventorySlotHolder.class);
        if (holder == null) {
            throw new JsonSyntaxException("Unknown slot '" + slotName + "'");
        }
        int index = ElementTypeSlot.resolveEquationInt(json, "index", ctx);
        if (index < 0 || index >= holder.slots.length) {
            throw new JsonSyntaxException("Invalid slot index! (" + index + ", min = 0, max = " + (holder.slots.length - 1) + ")");
        }
        return new GuiElementSlotMover(gui, pos, visible, holder.slots[index]);
    }
}

