/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern.parameter;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum PatternParameterRotation implements IStatementParameter
{
    NONE,
    QUARTER,
    HALF,
    THREE_QUARTERS;

    private static final PatternParameterRotation[] POSSIBLE_ORDER;
    public final int rotationCount = this.ordinal();

    public static PatternParameterRotation readFromNbt(NBTTagCompound nbt) {
        byte d = nbt.func_74771_c("d");
        return PatternParameterRotation.values()[d & 3];
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74774_a("d", (byte)this.rotationCount);
    }

    public String getUniqueTag() {
        return "buildcraft:fillerParameterRotation";
    }

    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        return BCBuildersSprites.PARAM_ROTATION[this.rotationCount];
    }

    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    public String getDescription() {
        return LocaleUtil.localize((String)("buildcraft.param.rotation." + this.rotationCount));
    }

    public PatternParameterRotation onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return null;
    }

    public IStatementParameter rotateLeft() {
        return this;
    }

    public IStatementParameter[] getPossible(IStatementContainer source) {
        return POSSIBLE_ORDER;
    }

    public boolean isPossibleOrdered() {
        return true;
    }

    static {
        POSSIBLE_ORDER = new PatternParameterRotation[]{null, null, NONE, null, QUARTER, null, HALF, null, THREE_QUARTERS};
    }
}

