/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.builders.snapshot.NbtPath;
import buildcraft.lib.misc.NBTUtilBC;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class NbtRef<N extends NBTBase> {
    private final EnumType type;
    private final NbtPath path;
    private final N value;
    public static final TypeAdapterFactory TYPE_ADAPTER_FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (type.getRawType() != NbtRef.class) {
                return null;
            }
            final Class nClass = (Class)((ParameterizedType)type.getType()).getActualTypeArguments()[0];
            if (nClass == NBTTagByteArray.class || nClass == NBTTagIntArray.class || nClass == NBTTagList.class) {
                return new TypeAdapter<T>(){

                    public void write(JsonWriter out, T value) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    public T read(JsonReader in) throws IOException {
                        if (in.peek() != JsonToken.BEGIN_ARRAY) {
                            return EnumType.BY_PATH.create((NbtPath)((Map)gson.fromJson(in, new TypeToken<Map<String, NbtPath>>(){}.getType())).get("ref"));
                        }
                        return EnumType.BY_VALUE.create((NBTBase)gson.fromJson(in, (Type)nClass));
                    }
                };
            }
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    throw new UnsupportedOperationException();
                }

                public T read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.BEGIN_ARRAY) {
                        return EnumType.BY_PATH.create((NbtPath)gson.fromJson(in, NbtPath.class));
                    }
                    return EnumType.BY_VALUE.create((NBTBase)gson.fromJson(in, (Type)nClass));
                }
            };
        }
    };

    private NbtRef(EnumType type, NbtPath path, N value) {
        this.type = type;
        this.path = path;
        this.value = value;
    }

    public Optional<N> get(NBTBase nbt) {
        if (this.type == EnumType.BY_PATH) {
            return NBTUtilBC.toOptional((NBTBase)this.path.get(nbt));
        }
        if (this.type == EnumType.BY_VALUE) {
            return NBTUtilBC.toOptional(this.value);
        }
        throw new IllegalStateException();
    }

    public String toString() {
        if (this.type == EnumType.BY_PATH) {
            return "NbtRef{path=" + this.path + "}";
        }
        if (this.type == EnumType.BY_VALUE) {
            return "NbtRef{value=" + this.value + "}";
        }
        throw new IllegalStateException();
    }

    /* synthetic */ NbtRef(EnumType x0, NbtPath x1, NBTBase x2, 1 x3) {
        this(x0, x1, x2);
    }

    public static enum EnumType {
        BY_PATH{

            @Override
            public NbtRef<?> create(NbtPath path) {
                return new NbtRef(this, path, null, null);
            }
        }
        ,
        BY_VALUE{

            @Override
            public <N extends NBTBase> NbtRef<N> create(N value) {
                return new NbtRef(this, null, value, null);
            }
        };


        public NbtRef<?> create(NbtPath path) {
            throw new UnsupportedOperationException();
        }

        public <N extends NBTBase> NbtRef<N> create(N value) {
            throw new UnsupportedOperationException();
        }
    }
}

