/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.item;

import buildcraft.api.enums.EnumSnapshotType;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.HashUtil;
import buildcraft.lib.misc.LocaleUtil;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSnapshot
extends ItemBC_Neptune {
    public ItemSnapshot(String id) {
        super(id);
        this.func_77627_a(true);
    }

    public ItemStack getClean(EnumSnapshotType snapshotType) {
        return new ItemStack((Item)this, 1, EnumItemSnapshotType.get(snapshotType, false).ordinal());
    }

    public ItemStack getUsed(EnumSnapshotType snapshotType, Snapshot.Header header) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("header", (NBTBase)header.serializeNBT());
        ItemStack stack = new ItemStack((Item)this, 1, EnumItemSnapshotType.get(snapshotType, true).ordinal());
        stack.func_77982_d(nbt);
        return stack;
    }

    public Snapshot.Header getHeader(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77973_b() instanceof ItemSnapshot && EnumItemSnapshotType.getFromStack((ItemStack)stack).used && (nbt = stack.func_77978_p()) != null && nbt.func_150297_b("header", 10)) {
            return new Snapshot.Header(nbt.func_74775_l("header"));
        }
        return null;
    }

    public int getItemStackLimit(ItemStack stack) {
        return EnumItemSnapshotType.getFromStack((ItemStack)stack).used ? 1 : 16;
    }

    protected void addSubItems(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)this.getClean(EnumSnapshotType.BLUEPRINT));
        subItems.add((Object)this.getClean(EnumSnapshotType.TEMPLATE));
    }

    @SideOnly(value=Side.CLIENT)
    public void addModelVariants(TIntObjectHashMap<ModelResourceLocation> variants) {
        for (EnumItemSnapshotType type : EnumItemSnapshotType.values()) {
            this.addVariant(variants, type.ordinal(), type.func_176610_l());
        }
    }

    public String func_77667_c(ItemStack stack) {
        EnumItemSnapshotType type = EnumItemSnapshotType.getFromStack(stack);
        if (type.snapshotType == EnumSnapshotType.BLUEPRINT) {
            return "item.blueprintItem";
        }
        return "item.templateItem";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        Snapshot.Header header = this.getHeader(stack);
        if (header == null) {
            tooltip.add(LocaleUtil.localize((String)"item.blueprint.blank"));
        } else {
            tooltip.add(header.name);
            EntityPlayer owner = header.getOwnerPlayer(world);
            if (owner != null) {
                tooltip.add(LocaleUtil.localize((String)"item.blueprint.author") + " " + owner.func_70005_c_());
            }
            if (flag.func_194127_a()) {
                tooltip.add("Hash: " + HashUtil.convertHashToString((byte[])header.key.hash));
                tooltip.add("Date: " + header.created);
                tooltip.add("Owner UUID: " + header.owner);
            }
        }
    }

    public static enum EnumItemSnapshotType implements IStringSerializable
    {
        TEMPLATE_CLEAN(EnumSnapshotType.TEMPLATE, false),
        TEMPLATE_USED(EnumSnapshotType.TEMPLATE, true),
        BLUEPRINT_CLEAN(EnumSnapshotType.BLUEPRINT, false),
        BLUEPRINT_USED(EnumSnapshotType.BLUEPRINT, true);

        public final EnumSnapshotType snapshotType;
        public final boolean used;

        private EnumItemSnapshotType(EnumSnapshotType snapshotType, boolean used) {
            this.snapshotType = snapshotType;
            this.used = used;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static EnumItemSnapshotType get(EnumSnapshotType snapshotType, boolean used) {
            if (snapshotType == EnumSnapshotType.TEMPLATE) {
                return !used ? TEMPLATE_CLEAN : TEMPLATE_USED;
            }
            if (snapshotType == EnumSnapshotType.BLUEPRINT) {
                return !used ? BLUEPRINT_CLEAN : BLUEPRINT_USED;
            }
            throw new IllegalArgumentException();
        }

        public static EnumItemSnapshotType getFromStack(ItemStack stack) {
            return EnumItemSnapshotType.values()[Math.abs(stack.func_77960_j()) % EnumItemSnapshotType.values().length];
        }
    }
}

