/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.container;

import buildcraft.builders.snapshot.Snapshot;
import buildcraft.builders.tile.TileElectronicLibrary;
import buildcraft.lib.gui.ContainerBCTile;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.slot.SlotBase;
import buildcraft.lib.gui.slot.SlotOutput;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.IItemHandlerAdv;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ContainerElectronicLibrary
extends ContainerBCTile<TileElectronicLibrary> {
    private static final IdAllocator IDS = ContainerBC_Neptune.IDS.makeChild("electronic_library");
    private static final int ID_SELECTED = IDS.allocId("SELECTED");

    public ContainerElectronicLibrary(EntityPlayer player, TileElectronicLibrary tile) {
        super(player, (TileBC_Neptune)tile);
        this.addFullPlayerInventory(138);
        this.func_75146_a((Slot)new SlotOutput((IItemHandlerAdv)tile.invDownOut, 0, 175, 57));
        this.func_75146_a((Slot)new SlotBase((IItemHandlerAdv)tile.invDownIn, 0, 219, 57));
        this.func_75146_a((Slot)new SlotBase((IItemHandlerAdv)tile.invUpIn, 0, 175, 79));
        this.func_75146_a((Slot)new SlotOutput((IItemHandlerAdv)tile.invUpOut, 0, 219, 79));
    }

    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public void sendSelectedToServer(Snapshot.Key selected) {
        this.sendMessage(ID_SELECTED, buffer -> {
            buffer.writeBoolean(selected != null);
            if (selected != null) {
                selected.writeToByteBuf(buffer);
            }
        });
    }

    public void readMessage(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readMessage(id, buffer, side, ctx);
        if (side == Side.SERVER && id == ID_SELECTED) {
            ((TileElectronicLibrary)this.tile).selected = buffer.readBoolean() ? new Snapshot.Key(buffer) : null;
            ((TileElectronicLibrary)this.tile).sendNetworkUpdate(TileBC_Neptune.NET_RENDER_DATA);
        }
    }
}

