/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import forestry.core.triggers.Trigger;
import forestry.core.utils.InventoryUtil;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarmHatch;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TriggerLowGermlings
extends Trigger {
    private final float threshold;

    public TriggerLowGermlings(String tag, float threshold) {
        super(tag, "lowGermlings", "low_germlings");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold * 100.0f + "%";
    }

    public boolean isTriggerActive(TileEntity tile, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        if (!(tile instanceof TileFarmHatch)) {
            return false;
        }
        TileFarmHatch tileHatch = (TileFarmHatch)tile;
        IInventory germlingsInventory = ((MultiblockLogicFarm)tileHatch.getMultiblockLogic()).getController().getFarmInventory().getGermlingsInventory();
        return !InventoryUtil.containsPercent(germlingsInventory, this.threshold);
    }
}

