/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.compat.mj;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.IMjRedstoneReceiver;
import buildcraft.api.mj.MjAPI;
import forestry.core.utils.Log;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.Optional;

public class MjHelper {
    @Nullable
    @CapabilityInject(value=IMjConnector.class)
    public static Capability<IMjConnector> CAP_CONNECTOR = null;
    @Nullable
    @CapabilityInject(value=IMjReceiver.class)
    public static Capability<IMjReceiver> CAP_RECEIVER = null;
    @Nullable
    @CapabilityInject(value=IMjRedstoneReceiver.class)
    public static Capability<IMjRedstoneReceiver> CAP_REDSTONE_RECEIVER = null;
    @Nullable
    @CapabilityInject(value=IMjReadable.class)
    public static Capability<IMjReadable> CAP_READABLE = null;
    @Nullable
    @CapabilityInject(value=IMjPassiveProvider.class)
    public static Capability<IMjPassiveProvider> CAP_PASSIVE_PROVIDER = null;

    public static boolean isLoaded() {
        return CAP_CONNECTOR != null && CAP_RECEIVER != null && CAP_REDSTONE_RECEIVER != null && CAP_READABLE != null && CAP_PASSIVE_PROVIDER != null;
    }

    public static boolean isEnergyReceiver(TileEntity tile, EnumFacing side) {
        return MjHelper.isLoaded() && MjHelper._isEnergyReceiver(tile, side);
    }

    public static int sendEnergy(TileEntity tile, EnumFacing side, int amount, boolean simulate) {
        if (MjHelper.isLoaded()) {
            return MjHelper.mjToRf(MjHelper._sendEnergy(tile, side, MjHelper.rfToMj(amount), simulate));
        }
        return 0;
    }

    @Optional.Method(modid="buildcraftlib")
    private static boolean _isEnergyReceiver(TileEntity tile, EnumFacing side) {
        return CAP_RECEIVER != null && tile.hasCapability(CAP_RECEIVER, side);
    }

    @Optional.Method(modid="buildcraftlib")
    private static int _sendEnergy(TileEntity tile, EnumFacing side, int amount, boolean simulate) {
        long amountMicro = MjHelper.toMicroJoules(amount);
        IMjReceiver consumer = (IMjReceiver)tile.getCapability(CAP_RECEIVER, side);
        if (consumer == null) {
            if (tile.hasCapability(CAP_RECEIVER, side)) {
                Log.error("Tile claims to support MJ but does not have the capability. {} {}", tile.func_174877_v(), tile);
            }
            return 0;
        }
        long req = consumer.getPowerRequested();
        return MjHelper.fromMicroJoules(amountMicro - consumer.receivePower(Math.min(amountMicro, req), simulate) - Math.max(0L, amountMicro - req));
    }

    public static boolean isMjCapability(Capability<?> capability) {
        if (!MjHelper.isLoaded()) {
            return false;
        }
        return capability == CAP_CONNECTOR || capability == CAP_RECEIVER || capability == CAP_REDSTONE_RECEIVER || capability == CAP_READABLE || capability == CAP_PASSIVE_PROVIDER;
    }

    public static int fromMicroJoules(long microJoules) {
        return (int)(microJoules / MjAPI.MJ);
    }

    public static long toMicroJoules(long mj) {
        return mj * MjAPI.MJ;
    }

    public static int rfToMj(int rf) {
        return rf / 10;
    }

    public static int mjToRf(int mj) {
        return mj * 10;
    }

    public static long rfToMicro(int rf) {
        return MjHelper.toMicroJoules(MjHelper.rfToMj(rf));
    }

    public static int microToRf(long microJoules) {
        return MjHelper.mjToRf(MjHelper.fromMicroJoules(microJoules));
    }
}

