/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.google.common.base.Preconditions;
import forestry.api.core.IModelManager;
import forestry.core.blocks.IMachineProperties;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.MigrationHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineProperties<T extends TileForestry>
implements IMachineProperties<T> {
    private final String name;
    private final Class<T> teClass;
    private final AxisAlignedBB boundingBox;
    @Nullable
    private Block block;

    public MachineProperties(Class<T> teClass, String name) {
        this(teClass, name, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    public MachineProperties(Class<T> teClass, String name, AxisAlignedBB boundingBox) {
        this.teClass = teClass;
        this.name = name;
        this.boundingBox = boundingBox;
    }

    @Override
    public void setBlock(Block block) {
        this.block = block;
    }

    @Override
    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.boundingBox;
    }

    @Override
    @Nullable
    public RayTraceResult collisionRayTrace(World world, BlockPos pos, IBlockState state, Vec3d startVec, Vec3d endVec) {
        return BlockUtil.collisionRayTrace(pos, startVec, endVec, this.boundingBox);
    }

    @Override
    public void registerTileEntity() {
        TileUtil.registerTile(this.teClass, this.name);
        MigrationHelper.addTileRemappingName(this.name, this.name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ResourceLocation itemNameFromRegistry = item.getRegistryName();
        Preconditions.checkNotNull((Object)itemNameFromRegistry, (Object)"No registry name for item");
        String identifier = itemNameFromRegistry.func_110623_a();
        manager.registerItemModel(item, 0, identifier);
    }

    @Override
    public TileEntity createTileEntity() {
        try {
            return (TileEntity)this.teClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate tile entity of class " + this.teClass.getName(), e);
        }
    }

    @Override
    public Class<T> getTeClass() {
        return this.teClass;
    }

    public String func_176610_l() {
        return this.name;
    }

    @Override
    public boolean isFullCube(IBlockState state) {
        return true;
    }
}

