/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.network.packets;

import forestry.api.climate.IClimateHousing;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketHandlerServer;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PacketSelectClimateTargeted
extends ForestryPacket
implements IForestryPacketServer {
    private final BlockPos pos;
    private final IClimateState climateState;

    public PacketSelectClimateTargeted(BlockPos pos, IClimateState climateState) {
        this.pos = pos;
        this.climateState = climateState;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.SELECT_CLIMATE_TARGETED;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        data.writeClimateState(this.climateState);
    }

    public static class Handler
    implements IForestryPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferForestry data, EntityPlayerMP player) {
            BlockPos pos = data.func_179259_c();
            IClimateState climateState = data.readClimateState();
            IClimateHousing housing = TileUtil.getTile((IBlockAccess)player.field_70170_p, pos, IClimateHousing.class);
            if (housing != null) {
                IClimateTransformer transformer = housing.getTransformer();
                transformer.setTarget(climateState);
            }
        }
    }
}

