/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.charcoal;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.ICharcoalManager;
import forestry.api.arboriculture.ICharcoalPileWall;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.charcoal.CharcoalPileWall;
import forestry.core.config.Config;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public class CharcoalManager
implements ICharcoalManager {
    private final List<ICharcoalPileWall> walls = TreeManager.pileWalls;

    @Override
    public void registerWall(Block block, int amount) {
        Preconditions.checkNotNull((Object)block, (Object)"block must not be null.");
        Preconditions.checkArgument((amount > -Config.charcoalAmountBase && amount < 63 - Config.charcoalAmountBase ? 1 : 0) != 0, (Object)"amount must be bigger than -10 and smaller than 64.");
        this.walls.add(new CharcoalPileWall(block, amount));
    }

    @Override
    public void registerWall(IBlockState blockState, int amount) {
        Preconditions.checkNotNull((Object)blockState, (Object)"block state must not be null.");
        Preconditions.checkArgument((amount > -Config.charcoalAmountBase && amount < 63 - Config.charcoalAmountBase ? 1 : 0) != 0, (Object)"amount must be bigger than -10 and smaller than 64.");
        this.walls.add(new CharcoalPileWall(blockState, amount));
    }

    @Override
    public void registerWall(ICharcoalPileWall wall) {
        this.walls.add(wall);
    }

    @Override
    public boolean removeWall(Block block) {
        return this.removeWall(block.func_176223_P());
    }

    @Override
    public boolean removeWall(IBlockState state) {
        for (ICharcoalPileWall wall : this.walls) {
            if (!wall.matches(state)) continue;
            return this.walls.remove(wall);
        }
        return false;
    }

    @Override
    public Collection<ICharcoalPileWall> getWalls() {
        return this.walls;
    }
}

