/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.states;

import com.carpentersblocks.util.ModLogger;
import com.carpentersblocks.util.states.State;
import com.carpentersblocks.util.states.StateMap;
import com.carpentersblocks.util.states.StatePart;
import com.carpentersblocks.util.states.loader.Vec3f;
import com.carpentersblocks.util.states.loader.dto.StateDTO;
import com.carpentersblocks.util.states.loader.dto.StateMapDTO;
import com.carpentersblocks.util.states.loader.dto.StatePartDTO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

public class StateMapConverter {
    private static final String RGB_VALIDATION_REGEX = "^(#?|0x)([A-Fa-f0-9]{6})$";
    private static final String RGB_REGEX = "0x|#";
    private static final String RENDER_LAYER_REGEX = "( +|_+)+";
    private static final String RENDER_FACE_REGEX = "^\\s+([-+]?[xXyYzZ]{1}|(?i)all|down|up|north|south|west|east(?-i))\\s*$";
    private static final Vec3d DEFAULT_MIN_VECTOR = new Vec3d(0.0, 0.0, 0.0);
    private static final Vec3d DEFAULT_MAX_VECTOR = new Vec3d(1.0, 1.0, 1.0);
    private StateMapDTO _stateMapDto;

    public StateMapConverter(StateMapDTO stateMapDto) {
        this._stateMapDto = stateMapDto;
    }

    public StateMap convert() {
        StateMap stateMap = new StateMap();
        for (Map.Entry stateDtoEntry : this._stateMapDto.entrySet()) {
            String stateDtoKey = (String)stateDtoEntry.getKey();
            StateDTO stateDto = (StateDTO)stateDtoEntry.getValue();
            State state = new State();
            stateMap.putState(stateDtoKey, state);
            HashMap<String, StatePart> statePartMap = new HashMap<String, StatePart>();
            state.setStateParts(statePartMap);
            for (Map.Entry<String, StatePartDTO> statePartDtoEntry : stateDto.getParts().entrySet()) {
                String statePartDtoKey = statePartDtoEntry.getKey();
                StatePartDTO statePartDto = statePartDtoEntry.getValue();
                StatePart statePart = new StatePart();
                statePartMap.put(statePartDtoKey, statePart);
                statePart.setMaxBrightness(statePartDto.isMaxBrightness());
                statePart.setRenderFaces(this.getRenderFaces(statePartDto));
                statePart.setRenderLayer(this.getRenderLayer(statePartDto));
                statePart.setRgb(this.getRgb(statePartDto));
                statePart.setIconName(statePartDto.getIconName());
                Vec3d vec1 = this.getVertexMin(statePartDto);
                Vec3d vec2 = this.getVertexMax(statePartDto);
                Vec3d minVec = new Vec3d(Math.min(vec1.field_72450_a, vec2.field_72450_a), Math.min(vec1.field_72448_b, vec2.field_72448_b), Math.min(vec1.field_72449_c, vec2.field_72449_c));
                Vec3d maxVec = new Vec3d(Math.max(vec1.field_72450_a, vec2.field_72450_a), Math.max(vec1.field_72448_b, vec2.field_72448_b), Math.max(vec1.field_72449_c, vec2.field_72449_c));
                statePart.setVertexMin(minVec);
                statePart.setVertexMax(maxVec);
            }
        }
        return stateMap;
    }

    private Set<EnumFacing> getRenderFaces(StatePartDTO statePartDto) {
        HashSet<EnumFacing> set = new HashSet<EnumFacing>();
        if (statePartDto.getRenderFaces() == null) {
            set.addAll(Arrays.asList(EnumFacing.values()));
        } else {
            block0: for (String value : statePartDto.getRenderFaces()) {
                if ("all".equalsIgnoreCase(value.trim())) {
                    set.addAll(Arrays.asList(EnumFacing.values()));
                    break;
                }
                value = value.trim();
                for (EnumFacing enumFacing : EnumFacing.values()) {
                    String direction = EnumFacing.AxisDirection.POSITIVE.equals((Object)enumFacing.func_176743_c()) ? "+" : "-";
                    String axis = enumFacing.func_176740_k().func_176610_l();
                    if (!value.equalsIgnoreCase(enumFacing.func_176610_l()) && !value.equalsIgnoreCase(axis) && !value.equalsIgnoreCase(direction + axis)) continue;
                    set.add(enumFacing);
                    continue block0;
                }
            }
        }
        return set;
    }

    private BlockRenderLayer getRenderLayer(StatePartDTO statePartDto) {
        if (statePartDto.getRenderLayer() != null) {
            String[] renderLayerArr1 = statePartDto.getRenderLayer().toLowerCase().split(RENDER_LAYER_REGEX);
            for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                HashSet<String> set2;
                String[] renderLayerArr2 = blockRenderLayer.toString().toLowerCase().split(RENDER_LAYER_REGEX);
                HashSet<String> set1 = new HashSet<String>(Arrays.asList(renderLayerArr1));
                if (!set1.equals(set2 = new HashSet<String>(Arrays.asList(renderLayerArr2)))) continue;
                return blockRenderLayer;
            }
        }
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    private int getRgb(StatePartDTO statePartDto) {
        int value = 0xFFFFFF;
        String rgb = statePartDto.getRgb();
        if (rgb != null) {
            Pattern pattern = Pattern.compile(RGB_VALIDATION_REGEX);
            Matcher matcher = pattern.matcher(rgb);
            if (matcher.matches()) {
                String temp = statePartDto.getRgb().toLowerCase().replaceAll(RGB_REGEX, "");
                value = Integer.decode("0x" + temp);
            } else {
                ModLogger.warning("Incorrect format used for rgb: " + rgb, new Object[0]);
            }
        }
        return value;
    }

    private Vec3d getVertexMin(StatePartDTO statePartDto) {
        Vec3d value = DEFAULT_MIN_VECTOR;
        Vec3f vec3f = statePartDto.getVertexMin();
        if (vec3f != null) {
            value = new Vec3d((double)(vec3f.getX() / 16.0f), (double)(vec3f.getY() / 16.0f), (double)(vec3f.getZ() / 16.0f));
        }
        return value;
    }

    private Vec3d getVertexMax(StatePartDTO statePartDto) {
        Vec3d value = DEFAULT_MAX_VECTOR;
        Vec3f vec3f = statePartDto.getVertexMax();
        if (vec3f != null) {
            value = new Vec3d((double)(vec3f.getX() / 16.0f), (double)(vec3f.getY() / 16.0f), (double)(vec3f.getZ() / 16.0f));
        }
        return value;
    }
}

