/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block.data;

import com.carpentersblocks.block.data.RotatableData;
import com.carpentersblocks.tileentity.CbTileEntity;

public class SlopeData
extends RotatableData {
    private static final int TYPE_BITMASK = 1984;
    private static final int TYPE_BITSHIFT = 6;

    public static Type getType(int cbMetadata) {
        int temp = (cbMetadata & 0x7C0) >> 6;
        for (Type type : Type.values()) {
            if (type.ordinal() != temp) continue;
            return type;
        }
        return Type.values()[0];
    }

    public static void setNextType(CbTileEntity cbTileEntity) {
        Type type = SlopeData.getType(cbTileEntity.getCbMetadata());
        int newType = type.ordinal() + 1;
        if (newType > Type.values().length) {
            newType = 0;
        }
        int temp = cbTileEntity.getCbMetadata();
        temp &= 0xFFFFF83F;
        cbTileEntity.setCbMetadata(temp |= newType << 6);
    }

    public static void setType(CbTileEntity cbTileEntity, Type type) {
        int typOrd = type.ordinal();
        int temp = cbTileEntity.getCbMetadata();
        temp &= 0xFFFFF83F;
        cbTileEntity.setCbMetadata(temp |= typOrd << 6);
    }

    public static enum Type {
        WEDGE,
        WEDGE_INTERIOR,
        WEDGE_EXTERIOR,
        OBLIQUE_INTERIOR,
        OBLIQUE_EXTERIOR,
        PRISM_WEDGE,
        PRISM,
        PRISM_1P,
        PRISM_2P,
        PRISM_3P,
        PRISM_4P,
        INVERT_PRISM,
        INVERT_PRISM_1P,
        INVERT_PRISM_2P,
        INVERT_PRISM_3P,
        INVERT_PRISM_4P;

    }
}

