/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.block.state.Property;
import com.carpentersblocks.tileentity.CbTileEntity;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class BlockFacing
extends BlockCoverable {
    public BlockFacing(Material material) {
        super(material);
    }

    public abstract void setFacing(CbTileEntity var1, EnumFacing var2);

    public abstract EnumFacing getFacing(CbTileEntity var1);

    public boolean func_176198_a(World world, BlockPos blockPos, EnumFacing facing) {
        if (this.canAttachToFacing(facing)) {
            return world.isSideSolid(blockPos.func_177972_a(facing.func_176734_d()), facing);
        }
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos blockPos, EnumFacing facing, float hitX, float hitY, float hitZ, int metadata, EntityLivingBase entityLivingBase) {
        return this.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)facing);
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, IBlockState blockState, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        CbTileEntity cbTileEntity;
        super.func_180633_a(world, blockPos, blockState, entityLivingBase, itemStack);
        if (!this.ignoreSidePlacement() && (cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos)) != null) {
            EnumFacing facing = (EnumFacing)blockState.func_177228_b().get((Object)BlockDirectional.field_176387_N);
            this.setFacing(cbTileEntity, facing);
        }
        world.func_175685_c(blockPos, (Block)this, false);
    }

    protected boolean ignoreSidePlacement() {
        return false;
    }

    public int func_149738_a(World world) {
        return 20;
    }

    @Override
    public void onNeighborChange(IBlockAccess blockAccess, BlockPos blockPos, BlockPos neighborBlockPos) {
        super.onNeighborChange(blockAccess, blockPos, neighborBlockPos);
        World world = (World)blockAccess;
        CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
        if (cbTileEntity == null || this.func_176198_a(world, blockPos, this.getFacing(cbTileEntity)) || !this.canFloat()) {
            // empty if block
        }
    }

    public void notifyBlocksOfPowerChange(World world, IBlockState blockState, BlockPos blockPos) {
        world.func_190524_a(blockPos, (Block)this, blockPos);
        if (this.func_149744_f(blockState)) {
            CbTileEntity cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos);
            if (cbTileEntity != null) {
                EnumFacing facing = this.getFacing(cbTileEntity);
                BlockPos pos = blockPos.func_177972_a(facing.func_176734_d());
                world.func_190524_a(pos, (Block)this, pos);
            } else {
                world.func_175685_c(blockPos, (Block)this, false);
            }
        }
    }

    @Override
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos, EnumFacing facing) {
        CbTileEntity cbTileEntity;
        int power = super.func_180656_a(blockState, blockAccess, blockPos, facing);
        if (this.func_149744_f(blockState) && (cbTileEntity = this.getTileEntity(blockAccess, blockPos)) != null) {
            power = Math.max(power, this.getPowerOutput(cbTileEntity));
        }
        return power;
    }

    @Override
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos, EnumFacing facing) {
        CbTileEntity cbTileEntity;
        int power = super.func_176211_b(blockState, blockAccess, blockPos, facing);
        if (this.func_149744_f(blockState) && (cbTileEntity = this.getTileEntity(blockAccess, blockPos)) != null && facing.equals((Object)this.getFacing(cbTileEntity))) {
            power = Math.max(power, this.getPowerOutput(cbTileEntity));
        }
        return power;
    }

    public void func_180663_b(World world, BlockPos blockPos, IBlockState blockState) {
        if (this.func_149744_f(blockState)) {
            this.notifyBlocksOfPowerChange(world, blockState, blockPos);
        }
        super.func_180663_b(world, blockPos, blockState);
    }

    public int getPowerOutput(CbTileEntity cbTileEntity) {
        return 0;
    }

    public boolean canAttachToFacing(EnumFacing facing) {
        return true;
    }

    public boolean canFloat() {
        return false;
    }

    public boolean rotateBlock(World world, BlockPos blockPos, EnumFacing axis) {
        CbTileEntity cbTileEntity;
        if (Arrays.asList(this.getRotationAxes()).contains(axis) && (cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos)) != null) {
            EnumFacing enumFacing = this.getFacing(cbTileEntity);
        }
        return false;
    }

    protected EnumFacing.Axis[] getRotationAxes() {
        return new EnumFacing.Axis[]{EnumFacing.Axis.Y};
    }

    public void func_180650_b(World world, BlockPos blockPos, IBlockState blockState, Random rand) {
        CbTileEntity cbTileEntity;
        if (this.func_149744_f(blockState) && (cbTileEntity = this.getTileEntity((IBlockAccess)world, blockPos)) != null) {
            world.func_175685_c(blockPos, (Block)this, false);
            world.func_175685_c(blockPos.func_177972_a(this.getFacing(cbTileEntity).func_176734_d()), (Block)this, false);
        }
    }

    @Override
    public IBlockState getExtendedState(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos) {
        IBlockState outBlockState = super.getExtendedState(blockState, blockAccess, blockPos);
        CbTileEntity cbTileEntity = this.getTileEntity(blockAccess, blockPos);
        if (cbTileEntity != null) {
            EnumFacing facing = this.getFacing(cbTileEntity);
            return ((IExtendedBlockState)outBlockState).withProperty(Property.FACING, (Object)facing);
        }
        return outBlockState;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BlockDirectional.field_176387_N}, Property._unlistedProperties.toArray(new IUnlistedProperty[Property._unlistedProperties.size()]));
    }
}

