/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core;

import com.enderio.core.IEnderMod;
import com.enderio.core.api.common.config.IConfigHandler;
import com.enderio.core.common.CommonProxy;
import com.enderio.core.common.Handlers;
import com.enderio.core.common.Lang;
import com.enderio.core.common.OreDict;
import com.enderio.core.common.command.CommandReloadConfigs;
import com.enderio.core.common.command.CommandScoreboardInfo;
import com.enderio.core.common.compat.CompatRegistry;
import com.enderio.core.common.config.ConfigHandler;
import com.enderio.core.common.imc.IMCRegistry;
import com.enderio.core.common.mixin.SimpleMixinLoader;
import com.enderio.core.common.network.EnderPacketHandler;
import com.enderio.core.common.tweaks.Tweaks;
import com.enderio.core.common.util.EnderFileUtils;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.PermanentCache;
import com.enderio.core.common.util.stackable.Things;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.crash.CrashReportCategory;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="endercore", name="EnderCore", version="1.12.2-0.5.57", guiFactory="com.enderio.core.common.config.BaseConfigFactory", acceptedMinecraftVersions="[1.12.2]")
public class EnderCore
implements IEnderMod {
    @Nonnull
    public static final String MODID = "endercore";
    @Nonnull
    public static final String DOMAIN = "endercore".toLowerCase(Locale.US);
    @Nonnull
    public static final String NAME = "EnderCore";
    @Nonnull
    public static final String BASE_PACKAGE = "com.enderio";
    @Nonnull
    public static final String VERSION = "1.12.2-0.5.57";
    @Nonnull
    public static final Logger logger = NullHelper.notnull(LogManager.getLogger((String)"EnderCore"), "failed to aquire logger");
    @Nonnull
    public static final Lang lang = new Lang("endercore");
    @Mod.Instance(value="endercore")
    public static EnderCore instance;
    @SidedProxy(serverSide="com.enderio.core.common.CommonProxy", clientSide="com.enderio.core.client.ClientProxy")
    public static CommonProxy proxy;
    @Nonnull
    public final List<IConfigHandler> configs = Lists.newArrayList();
    @Nonnull
    private final Set<String> invisibleRequesters = Sets.newHashSet();

    public EnderCore() {
        SimpleMixinLoader.loadMixinSources(this);
    }

    public void requestInvisibleMode() {
        ModContainer activeModContainer = Loader.instance().activeModContainer();
        if (activeModContainer != null) {
            this.invisibleRequesters.add(activeModContainer.getName());
        } else {
            this.invisibleRequesters.add("null");
        }
    }

    public boolean invisibilityRequested() {
        return !this.invisibleRequesters.isEmpty();
    }

    @Nonnull
    public Set<String> getInvisibleRequsters() {
        return ImmutableSet.copyOf(this.invisibleRequesters);
    }

    @Mod.EventHandler
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        ConfigHandler.configFolder = event.getModConfigurationDirectory();
        ConfigHandler.enderConfigFolder = new File(ConfigHandler.configFolder.getPath() + "/" + MODID);
        ConfigHandler.configFile = new File(ConfigHandler.enderConfigFolder.getPath() + "/" + event.getSuggestedConfigurationFile().getName());
        if (!ConfigHandler.configFile.exists() && event.getSuggestedConfigurationFile().exists()) {
            try {
                FileUtils.copyFile((File)event.getSuggestedConfigurationFile(), (File)ConfigHandler.configFile);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            EnderFileUtils.safeDelete(event.getSuggestedConfigurationFile());
        }
        ConfigHandler.instance().initialize(NullHelper.notnullJ(ConfigHandler.configFile, "it was there a second ago, I swear!"));
        Handlers.preInit(event);
        CompatRegistry.INSTANCE.handle((FMLStateEvent)event);
        proxy.onPreInit(event);
    }

    @Mod.EventHandler
    public void init(@Nonnull FMLInitializationEvent event) {
        OreDict.registerVanilla();
        Things.init(event);
        EnderPacketHandler.init();
        for (IConfigHandler c : this.configs) {
            c.initHook();
        }
        Handlers.register(event);
        CompatRegistry.INSTANCE.handle((FMLStateEvent)event);
        if (event.getSide().isServer()) {
            ((CommandHandler)FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D()).func_71560_a((ICommand)CommandReloadConfigs.SERVER);
        } else {
            ClientCommandHandler.instance.func_71560_a((ICommand)CommandReloadConfigs.CLIENT);
        }
        IMCRegistry.INSTANCE.init();
    }

    @Mod.EventHandler
    public void postInit(@Nonnull FMLPostInitializationEvent event) {
        Tweaks.loadLateTweaks();
        for (IConfigHandler c : this.configs) {
            c.postInitHook();
        }
        CompatRegistry.INSTANCE.handle((FMLStateEvent)event);
        ConfigHandler.instance().loadRightClickCrops();
    }

    @Mod.EventHandler
    public void loadComplete(@Nonnull FMLLoadCompleteEvent event) {
        Things.init(event);
        ThreadPoolExecutor fixedChunkExecutor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new ThreadFactory(){
            private AtomicInteger count = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Chunk I/O Executor Thread-" + this.count.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            }
        }){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                if (t != null) {
                    try {
                        FMLLog.log.error("Unhandled exception loading chunk:", t);
                        Object queuedChunk = ReflectionHelper.getPrivateValue(r.getClass(), (Object)r, (String[])new String[]{"chunkInfo"});
                        Class<?> cls = queuedChunk.getClass();
                        FMLLog.log.error(queuedChunk);
                        int x = (Integer)ReflectionHelper.getPrivateValue(cls, (Object)queuedChunk, (String[])new String[]{"x"});
                        int z = (Integer)ReflectionHelper.getPrivateValue(cls, (Object)queuedChunk, (String[])new String[]{"z"});
                        FMLLog.log.error(CrashReportCategory.func_184876_a((int)(x << 4), (int)64, (int)(z << 4)));
                    }
                    catch (Throwable t2) {
                        FMLLog.log.error((Object)t2);
                    }
                }
            }
        };
        try {
            EnumHelper.setFailsafeFieldValue((Field)ReflectionHelper.findField(ChunkIOExecutor.class, (String[])new String[]{"pool"}), null, (Object)fixedChunkExecutor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Mod.EventHandler
    public void onServerStarting(@Nonnull FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandScoreboardInfo());
        PermanentCache.saveCaches();
    }

    @Mod.EventHandler
    public void onIMCEvent(@Nonnull FMLInterModComms.IMCEvent event) {
        IMCRegistry.INSTANCE.handleEvent(event);
    }

    @Override
    @Nonnull
    public String modid() {
        return MODID;
    }

    @Override
    @Nonnull
    public String name() {
        return NAME;
    }

    @Override
    @Nonnull
    public String version() {
        return VERSION;
    }
}

