/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.client.gui.element;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import p455w0rdslib.api.gui.IModularGui;
import p455w0rdslib.client.gui.element.GuiElement;
import p455w0rdslib.client.gui.element.GuiPos;
import p455w0rdslib.util.GuiUtils;

public class GuiCheckbox
extends GuiElement {
    private boolean isChecked;
    private boolean isHovered;
    private int boxWidth = 11;
    private String displayedText;

    public GuiCheckbox(IModularGui gui, GuiPos pos, String text, boolean checked, int width) {
        this(gui, pos, text, checked, width, false);
    }

    public GuiCheckbox(IModularGui gui, GuiPos pos, String text, boolean checked, int width, boolean checkBoxOnRight) {
        super(gui, pos, width, 11);
        this.isChecked = checked;
        this.displayedText = text;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.boxWidth && mouseY < this.getY() + this.getHeight();
            GuiUtils.drawContinuousTexturedBox((Gui)this.getGui(), VANILLA_BUTTON_TEXTURES, this.getX() + (this.getWidth() - this.boxWidth), this.getY(), 0, 46, this.boxWidth, this.getHeight(), 200, 20, 2, 3, 2, 2);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        int color = 0xE0E0E0;
        color = !this.isEnabled() ? 0xA0A0A0 : 0x404040;
        if (this.isChecked()) {
            GuiUtils.drawCenteredString("\u00e2\u0153\u201d", this.getX() + (this.getWidth() - this.boxWidth) + this.boxWidth / 2 + 1, this.getY() + 1, 65280);
        }
        GuiUtils.drawStringNoShadow(this.displayedText, this.getX(), this.getY() + 2, color);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void drawStringNoShadow(FontRenderer fontRenderer, String text, int x, int y, int color) {
        fontRenderer.func_78276_b(text, x, y, color);
    }

    @Override
    public boolean onClick(int x, int y) {
        if (x >= this.getX() && y >= this.getY() && x < this.getX() + this.getWidth() && y < this.getY() + this.getHeight()) {
            this.setChecked(!this.isChecked());
            return true;
        }
        return false;
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }
}

