/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.tile;

import buildcraft.api.core.BCLog;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.core.tile.ITileOilSpring;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileSpringOil
extends TileEntity
implements IDebuggable,
ITileOilSpring {
    private final Map<GameProfile, PlayerPumpInfo> pumpProgress = new ConcurrentHashMap<GameProfile, PlayerPumpInfo>();
    public int totalSources;

    public void onPumpOil(GameProfile profile, BlockPos oilPos) {
        if (profile == null) {
            return;
        }
        PlayerPumpInfo info = this.pumpProgress.computeIfAbsent(profile, PlayerPumpInfo::new);
        info.lastPumpTick = this.field_145850_b.func_82737_E();
        ++info.sourcesPumped;
        String name = profile.getName();
        if (info.sourcesPumped >= this.totalSources * 7 / 8 && oilPos.equals((Object)this.func_174877_v().func_177984_a())) {
            BCLog.logger.info("Awarding advancement to " + name + "! Or we would do, if this was 1.12...");
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("pumpProgress", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            PlayerPumpInfo info = new PlayerPumpInfo(list.func_150305_b(i));
            this.pumpProgress.put(info.profile, info);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("totalSources", this.totalSources);
        NBTTagList list = new NBTTagList();
        for (PlayerPumpInfo info : this.pumpProgress.values()) {
            list.func_74742_a((NBTBase)info.writeToNbt());
        }
        nbt.func_74782_a("pumpProgress", (NBTBase)list);
        return nbt;
    }

    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("totalSources = " + this.totalSources);
        boolean added = false;
        for (PlayerPumpInfo info : this.pumpProgress.values()) {
            if (!added) {
                left.add("Player Progress:");
                added = true;
            }
            left.add("  " + info.profile.getName() + " = " + info.sourcesPumped + " ( " + (this.field_145850_b.func_82737_E() - info.lastPumpTick) / 20L + "s )");
        }
    }

    static class PlayerPumpInfo {
        final GameProfile profile;
        long lastPumpTick = -1L;
        int sourcesPumped = 0;

        public PlayerPumpInfo(GameProfile profile) {
            this.profile = profile;
        }

        public PlayerPumpInfo(NBTTagCompound nbt) {
            this.profile = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("profile"));
            this.lastPumpTick = nbt.func_74763_f("lastPumpTick");
            this.sourcesPumped = nbt.func_74762_e("sourcesPumped");
        }

        public NBTTagCompound writeToNbt() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("profile", (NBTBase)NBTUtil.func_180708_a((NBTTagCompound)new NBTTagCompound(), (GameProfile)this.profile));
            nbt.func_74772_a("lastPumpTick", this.lastPumpTick);
            nbt.func_74768_a("sourcesPumped", this.sourcesPumped);
            return nbt;
        }
    }
}

