/*
 * Decompiled with CFR 0.152.
 */
package openmods.world;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class DelayedActionTickHandler {
    public static final DelayedActionTickHandler INSTANCE = new DelayedActionTickHandler();
    private Map<Integer, Queue<Runnable>> callbacks = Maps.newHashMap();

    private DelayedActionTickHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Queue<Runnable> getWorldQueue(int worldId) {
        Map<Integer, Queue<Runnable>> map = this.callbacks;
        synchronized (map) {
            ConcurrentLinkedQueue result = this.callbacks.get(worldId);
            if (result == null) {
                result = Queues.newConcurrentLinkedQueue();
                this.callbacks.put(worldId, result);
            }
            return result;
        }
    }

    public void addTickCallback(World world, Runnable callback) {
        int worldId = world.field_73011_w.getDimension();
        this.getWorldQueue(worldId).add(callback);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent evt) {
        if (evt.side == Side.SERVER && evt.phase == TickEvent.Phase.END) {
            Runnable callback;
            int worldId = evt.world.field_73011_w.getDimension();
            Queue<Runnable> callbacks = this.getWorldQueue(worldId);
            while ((callback = callbacks.poll()) != null) {
                callback.run();
            }
        }
    }
}

