/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.output.NullOutputStream;

public class ItemUtils {
    @Nonnull
    public static ItemStack consumeItem(@Nonnull ItemStack stack) {
        if (stack.func_190916_E() == 1) {
            Item item = stack.func_77973_b();
            if (item.hasContainerItem(stack)) {
                return item.getContainerItem(stack);
            }
            return ItemStack.field_190927_a;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static NBTTagCompound getItemTag(@Nonnull ItemStack stack) {
        NBTTagCompound result = stack.func_77978_p();
        if (result == null) {
            result = new NBTTagCompound();
            stack.func_77982_d(result);
        }
        return result;
    }

    public static EntityItem createDrop(Entity dropper, @Nonnull ItemStack is) {
        return ItemUtils.createEntityItem(dropper.field_70170_p, dropper.field_70165_t, dropper.field_70163_u, dropper.field_70161_v, is);
    }

    public static EntityItem createEntityItem(World world, double x, double y, double z, @Nonnull ItemStack is) {
        return new EntityItem(world, x, y, z, is.func_77946_l());
    }

    public static String getNBTHash(NBTTagCompound tag) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            NullOutputStream dump = new NullOutputStream();
            DigestOutputStream hasher = new DigestOutputStream((OutputStream)dump, digest);
            DataOutputStream output = new DataOutputStream(hasher);
            CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)output);
            byte[] hash = digest.digest();
            return new String(Hex.encodeHex((byte[])hash));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setEntityItemStack(EntityItem entity, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            entity.func_70106_y();
        } else {
            entity.func_92058_a(stack);
        }
    }
}

