/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer.shaders;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import openmods.renderer.shaders.ShaderHelper;
import openmods.renderer.shaders.ShaderProgram;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.lwjgl.opengl.OpenGLException;

public class ShaderProgramBuilder {
    private final Map<ResourceLocation, Integer> shadersToLoad = Maps.newLinkedHashMap();

    public void addShader(ResourceLocation source, int type) {
        this.shadersToLoad.put(source, type);
    }

    public ShaderProgram build() {
        int program = ShaderHelper.methods().glCreateProgram();
        ArrayList shaders = Lists.newArrayList();
        if (program == 0) {
            throw new OpenGLException("Error creating program object");
        }
        for (Map.Entry<ResourceLocation, Integer> e : this.shadersToLoad.entrySet()) {
            int shader = ShaderProgramBuilder.createShader(e.getKey(), e.getValue());
            ShaderHelper.methods().glAttachShader(program, shader);
            shaders.add(shader);
        }
        ShaderHelper.methods().glLinkProgram(program);
        if (ShaderHelper.methods().glGetProgrami(program, 35714) == 0) {
            throw new OpenGLException("Shader link error: " + ShaderHelper.methods().getProgramLogInfo(program));
        }
        for (Integer shader : shaders) {
            ShaderHelper.methods().glDetachShader(program, shader);
        }
        ShaderHelper.methods().glValidateProgram(program);
        if (ShaderHelper.methods().glGetProgrami(program, 35715) == 0) {
            throw new OpenGLException("Shader validate error: " + ShaderHelper.methods().getProgramLogInfo(program));
        }
        return new ShaderProgram(program, shaders);
    }

    private static int createShader(ResourceLocation source, int type) {
        int shader = 0;
        try {
            shader = ShaderHelper.methods().glCreateShader(type);
            if (shader == 0) {
                throw new OpenGLException("Error creating shader object");
            }
            ShaderHelper.methods().glShaderSource(shader, ShaderProgramBuilder.readShaderSource(source));
            ShaderHelper.methods().glCompileShader(shader);
            if (ShaderHelper.methods().glGetShaderi(shader, 35713) == 0) {
                throw new OpenGLException("Shader compile error: " + ShaderHelper.methods().getShaderLogInfo(shader));
            }
            return shader;
        }
        catch (Throwable t) {
            ShaderHelper.methods().glDeleteShader(shader);
            throw t;
        }
    }

    private static String readShaderSource(ResourceLocation source) {
        try {
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(source).func_110527_b();
            LineIterator lines = IOUtils.lineIterator((InputStream)is, (Charset)StandardCharsets.UTF_8);
            StringBuilder out = new StringBuilder();
            Joiner.on((char)'\n').appendTo(out, (Iterator)lines);
            return out.toString();
        }
        catch (IOException e) {
            throw new OpenGLException("Failed to read resource " + source, (Throwable)e);
        }
    }
}

