/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import openmods.utils.CommandUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.opengl.KHRDebugCallback;

public class CommandGlDebug
extends CommandBase {
    private static final List<String> STATES = ImmutableList.of((Object)"high", (Object)"medium", (Object)"low", (Object)"notification", (Object)"disable");
    private static final Set<Integer> ALL_LEVELS = ImmutableSet.of((Object)37190, (Object)37191, (Object)37192, (Object)33387);
    private static final Map<String, ? extends Set<Integer>> ALLOWED_LEVELS = ImmutableMap.of((Object)"notification", (Object)ImmutableSet.of((Object)37190, (Object)37191, (Object)37192, (Object)33387), (Object)"low", (Object)ImmutableSet.of((Object)37190, (Object)37191, (Object)37192), (Object)"medium", (Object)ImmutableSet.of((Object)37190, (Object)37191), (Object)"high", (Object)ImmutableSet.of((Object)37190));

    public String func_71517_b() {
        return "gl_debug";
    }

    public String func_71518_a(ICommandSender sender) {
        return "gl_debug high|medium|low|notification|disable";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            String state = args[0];
            return CommandUtils.filterPrefixes(state, STATES);
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new CommandException("commands.generic.syntax", new Object[0]);
        }
        String arg = args[0].toLowerCase(Locale.ROOT);
        if (arg.equals("disable")) {
            GL11.glDisable((int)37600);
        } else {
            Set<Integer> allowedLevels = ALLOWED_LEVELS.get(arg);
            if (allowedLevels == null) {
                throw new CommandException("commands.generic.syntax", new Object[0]);
            }
            GL11.glEnable((int)37600);
            for (int level : ALL_LEVELS) {
                boolean isEnabled = allowedLevels.contains(level);
                KHRDebug.glDebugMessageControl((int)4352, (int)4352, (int)level, null, (boolean)isEnabled);
            }
            KHRDebug.glDebugMessageCallback((KHRDebugCallback)new KHRDebugCallback());
        }
    }
}

