/*
 * Decompiled with CFR 0.152.
 */
package openmods.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import openmods.model.ModelTextureMap;
import openmods.model.ModelUpdater;
import openmods.utils.CollectionUtils;

public class ModelWithDependencies
implements IModel {
    public static final ModelWithDependencies EMPTY = new ModelWithDependencies(Optional.empty(), (Set<ResourceLocation>)ImmutableSet.of(), new ModelTextureMap());
    private final Optional<ResourceLocation> base;
    private final Set<ResourceLocation> dependencies;
    private final ModelTextureMap textures;

    private ModelWithDependencies(Optional<ResourceLocation> base, Set<ResourceLocation> dependencies, ModelTextureMap textures) {
        this.base = base;
        this.dependencies = ImmutableSet.copyOf(dependencies);
        this.textures = textures;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Sets.union(this.dependencies, CollectionUtils.asSet(this.base));
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures.getTextures();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel model = this.base.isPresent() ? ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.base.get(), (String)("Couldn't load MultiLayerModel dependency: " + this.base.get())) : ModelLoaderRegistry.getMissingModel();
        return model.bake(state, format, bakedTextureGetter);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater((Map<String, String>)customData);
        Optional<ResourceLocation> base = updater.get("base", ModelUpdater.MODEL_LOCATION, this.base);
        Set<ResourceLocation> dependencies = updater.get("dependencies", ModelUpdater.MODEL_LOCATION, this.dependencies);
        return updater.hasChanged() ? new ModelWithDependencies(base, dependencies, this.textures) : this;
    }

    public IModel retexture(ImmutableMap<String, String> updates) {
        Optional<ModelTextureMap> newTextures = this.textures.update((Map<String, String>)updates);
        return newTextures.isPresent() ? new ModelWithDependencies(this.base, this.dependencies, newTextures.get()) : this;
    }
}

