/*
 * Decompiled with CFR 0.152.
 */
package openmods.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import openmods.utils.CollectionUtils;
import openmods.utils.InventoryUtils;

public class ItemMover {
    private Set<EnumFacing> sides;
    private boolean randomizeSides = false;
    private boolean breakAfterFirstTry = false;
    private int maxSize = 64;
    private final World world;
    private final BlockPos pos;

    public ItemMover(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public ItemMover setSides(Set<EnumFacing> sides) {
        this.sides = sides;
        return this;
    }

    public ItemMover randomizeSides() {
        this.randomizeSides = true;
        return this;
    }

    public ItemMover breakAfterFirstTry() {
        this.breakAfterFirstTry = true;
        return this;
    }

    public ItemMover setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    private Collection<IItemHandler> findNeighbours() {
        if (this.sides.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.breakAfterFirstTry) {
            EnumFacing selectedSide = this.randomizeSides ? CollectionUtils.getRandom(this.sides) : CollectionUtils.getFirst(this.sides);
            IItemHandler neighbour = InventoryUtils.tryGetHandler(this.world, this.pos.func_177972_a(selectedSide), selectedSide.func_176734_d());
            return neighbour != null ? Collections.singletonList(neighbour) : Collections.emptyList();
        }
        Collection<Object> sidesToCheck = this.sides;
        if (this.randomizeSides) {
            ArrayList tmp = Lists.newArrayList(this.sides);
            Collections.shuffle(tmp);
            sidesToCheck = tmp;
        }
        ArrayList handlers = Lists.newArrayList();
        for (EnumFacing side : sidesToCheck) {
            IItemHandler neighbour = InventoryUtils.tryGetHandler(this.world, this.pos.func_177972_a(side), side.func_176734_d());
            if (neighbour == null) continue;
            handlers.add(neighbour);
        }
        return handlers;
    }

    public int pullToSlot(IItemHandler target, int targetSlot) {
        return ItemMover.pullToSlot(target, targetSlot, this.maxSize, this.findNeighbours());
    }

    static int pullToSlot(IItemHandler target, int targetSlot, int maxSize, Iterable<IItemHandler> sources) {
        int transferedAmount = 0;
        block0: for (IItemHandler source : sources) {
            for (int sourceSlot = 0; sourceSlot < source.getSlots(); ++sourceSlot) {
                ItemStack targetContents;
                ItemStack stackToPull = source.getStackInSlot(sourceSlot);
                if (stackToPull.func_190926_b()) continue;
                ItemStack leftover = target.insertItem(targetSlot, stackToPull, true);
                if (leftover.func_190916_E() < stackToPull.func_190916_E()) {
                    int leftoverAmount = leftover.func_190916_E();
                    int amountToExtract = Math.min(maxSize - transferedAmount, stackToPull.func_190916_E() - leftoverAmount);
                    ItemStack extractedItem = source.extractItem(sourceSlot, amountToExtract, false);
                    if (!extractedItem.func_190926_b()) {
                        target.insertItem(targetSlot, extractedItem, false);
                        transferedAmount += amountToExtract;
                    }
                }
                if ((targetContents = target.getStackInSlot(targetSlot)) != null && targetContents.func_190916_E() >= targetContents.func_77976_d()) break block0;
            }
        }
        return transferedAmount;
    }

    public int pushFromSlot(IItemHandler source, int sourceSlot) {
        return ItemMover.pushFromSlot(source, sourceSlot, this.maxSize, this.findNeighbours());
    }

    static int pushFromSlot(IItemHandler source, int sourceSlot, int maxSize, Iterable<IItemHandler> targets) {
        int transferedAmount = 0;
        block0: for (IItemHandler target : targets) {
            ItemStack stackToPush = source.getStackInSlot(sourceSlot);
            for (int targetSlot = 0; targetSlot < target.getSlots(); ++targetSlot) {
                if (stackToPush.func_190926_b()) break block0;
                ItemStack leftover = target.insertItem(targetSlot, stackToPush, true);
                if (leftover.func_190916_E() >= stackToPush.func_190916_E()) continue;
                int leftoverAmount = leftover.func_190916_E();
                int amountToExtract = Math.min(maxSize - transferedAmount, stackToPush.func_190916_E() - leftoverAmount);
                ItemStack extractedItem = source.extractItem(sourceSlot, amountToExtract, false);
                if (extractedItem.func_190926_b()) continue;
                target.insertItem(targetSlot, extractedItem, false);
                transferedAmount += extractedItem.func_190916_E();
                stackToPush = source.getStackInSlot(sourceSlot);
            }
        }
        return transferedAmount;
    }
}

