/*
 * Decompiled with CFR 0.152.
 */
package openmods.colors;

import openmods.colors.CYMK;

public class RGB {
    public int r;
    public int g;
    public int b;

    public RGB(float r, float g, float b) {
        this.r = (int)(r * 255.0f) & 0xFF;
        this.g = (int)(g * 255.0f) & 0xFF;
        this.b = (int)(b * 255.0f) & 0xFF;
    }

    public RGB(int r, int g, int b) {
        this.r = r & 0xFF;
        this.g = g & 0xFF;
        this.b = b & 0xFF;
    }

    public RGB(int color) {
        this((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF);
    }

    public RGB() {
    }

    public void setColor(int color) {
        this.r = (color & 0xFF0000) >> 16;
        this.g = (color & 0xFF00) >> 8;
        this.b = color & 0xFF;
    }

    public int getColor() {
        return this.r << 16 | this.g << 8 | this.b;
    }

    public float getR() {
        return (float)this.r / 255.0f;
    }

    public float getG() {
        return (float)this.g / 255.0f;
    }

    public float getB() {
        return (float)this.b / 255.0f;
    }

    public RGB interpolate(RGB other, double amount) {
        int iPolR = (int)((double)this.r * (1.0 - amount) + (double)other.r * amount);
        int iPolG = (int)((double)this.g * (1.0 - amount) + (double)other.g * amount);
        int iPolB = (int)((double)this.b * (1.0 - amount) + (double)other.b * amount);
        return new RGB(iPolR, iPolG, iPolB);
    }

    public CYMK toCYMK() {
        float cyan = 1.0f - (float)this.r / 255.0f;
        float magenta = 1.0f - (float)this.g / 255.0f;
        float yellow = 1.0f - (float)this.b / 255.0f;
        float K = 1.0f;
        if (cyan < K) {
            K = cyan;
        }
        if (magenta < K) {
            K = magenta;
        }
        if (yellow < K) {
            K = yellow;
        }
        if (K == 1.0f) {
            cyan = 0.0f;
            magenta = 0.0f;
            yellow = 0.0f;
        } else {
            cyan = (cyan - K) / (1.0f - K);
            magenta = (magenta - K) / (1.0f - K);
            yellow = (yellow - K) / (1.0f - K);
        }
        return new CYMK(cyan, yellow, magenta, K);
    }

    public int distance(RGB other) {
        int meanR = this.r + other.r >>> 1;
        int dR = this.r - other.r;
        int dG = this.g - other.g;
        int dB = this.b - other.b;
        int dR2 = dR * dR;
        int dG2 = dG * dG;
        int dB2 = dB * dB;
        return Math.abs(((512 + meanR) * dR2 >> 8) + (dG2 << 2) + ((767 - meanR) * dB2 >> 8));
    }
}

