/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Vector2dc;
import org.joml.Vector2fc;

public class Vector2f
implements Externalizable,
Vector2fc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(float d) {
        this(d, d);
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f(Vector2fc v) {
        this.x = v.x();
        this.y = v.y();
    }

    public Vector2f(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector2f(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector2f(FloatBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector2f(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public Vector2f set(float d) {
        return this.set(d, d);
    }

    public Vector2f set(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2f set(Vector2fc v) {
        this.x = v.x();
        this.y = v.y();
        return this;
    }

    public Vector2f set(Vector2dc v) {
        this.x = (float)v.x();
        this.y = (float)v.y();
        return this;
    }

    public Vector2f set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector2f set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector2f set(FloatBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector2f set(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector2f setComponent(int component, float value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector2f perpendicular() {
        return this.set(this.y, this.x * -1.0f);
    }

    public Vector2f sub(Vector2fc v) {
        this.x -= v.x();
        this.y -= v.y();
        return this;
    }

    public Vector2f sub(Vector2fc v, Vector2f dest) {
        dest.x = this.x - v.x();
        dest.y = this.y - v.y();
        return dest;
    }

    public Vector2f sub(float x, float y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector2f sub(float x, float y, Vector2f dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        return dest;
    }

    public float dot(Vector2fc v) {
        return this.x * v.x() + this.y * v.y();
    }

    public float angle(Vector2fc v) {
        float dot = this.x * v.x() + this.y * v.y();
        float det = this.x * v.y() - this.y * v.x();
        return (float)Math.atan2(det, dot);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float distance(Vector2fc v) {
        return this.distance(v.x(), v.y());
    }

    public float distanceSquared(Vector2fc v) {
        return this.distanceSquared(v.x(), v.y());
    }

    public float distance(float x, float y) {
        float dx = this.x - x;
        float dy = this.y - y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public float distanceSquared(float x, float y) {
        float dx = this.x - x;
        float dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public Vector2f normalize() {
        float invLength = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y));
        this.x *= invLength;
        this.y *= invLength;
        return this;
    }

    public Vector2f normalize(Vector2f dest) {
        float invLength = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y));
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        return dest;
    }

    public Vector2f add(Vector2fc v) {
        this.x += v.x();
        this.y += v.y();
        return this;
    }

    public Vector2f add(Vector2fc v, Vector2f dest) {
        dest.x = this.x + v.x();
        dest.y = this.y + v.y();
        return dest;
    }

    public Vector2f add(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector2f add(float x, float y, Vector2f dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        return dest;
    }

    public Vector2f zero() {
        this.x = 0.0f;
        this.y = 0.0f;
        return this;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readFloat();
        this.y = in.readFloat();
    }

    public Vector2f negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f negate(Vector2f dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        return dest;
    }

    public Vector2f mul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2f mul(float scalar, Vector2f dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        return dest;
    }

    public Vector2f mul(float x, float y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vector2f mul(float x, float y, Vector2f dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        return dest;
    }

    public Vector2f mul(Vector2fc v) {
        this.x *= v.x();
        this.y *= v.y();
        return this;
    }

    public Vector2f mul(Vector2fc v, Vector2f dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        return dest;
    }

    public Vector2f lerp(Vector2fc other, float t) {
        return this.lerp(other, t, this);
    }

    public Vector2f lerp(Vector2fc other, float t, Vector2f dest) {
        dest.x = this.x + (other.x() - this.x) * t;
        dest.y = this.y + (other.y() - this.y) * t;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector2f other = (Vector2f)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        String str = this.toString(formatter);
        StringBuffer res = new StringBuffer();
        int eIndex = Integer.MIN_VALUE;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == 'E') {
                eIndex = i;
            } else {
                if (c == ' ' && eIndex == i - 1) {
                    res.append('+');
                    continue;
                }
                if (Character.isDigit(c) && eIndex == i - 1) {
                    res.append('+');
                }
            }
            res.append(c);
        }
        return res.toString();
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + ")";
    }

    public Vector2f fma(Vector2fc a, Vector2fc b) {
        this.x += a.x() * b.x();
        this.y += a.y() * b.y();
        return this;
    }

    public Vector2f fma(float a, Vector2fc b) {
        this.x += a * b.x();
        this.y += a * b.y();
        return this;
    }

    public Vector2f fma(Vector2fc a, Vector2fc b, Vector2f dest) {
        dest.x = this.x + a.x() * b.x();
        dest.y = this.y + a.y() * b.y();
        return dest;
    }

    public Vector2f fma(float a, Vector2fc b, Vector2f dest) {
        dest.x = this.x + a * b.x();
        dest.y = this.y + a * b.y();
        return dest;
    }

    public Vector2fc toImmutable() {
        if (!Options.DEBUG) {
            return this;
        }
        return new Proxy(this);
    }

    private final class Proxy
    implements Vector2fc {
        private final Vector2fc delegate;

        Proxy(Vector2fc delegate) {
            this.delegate = delegate;
        }

        public float x() {
            return this.delegate.x();
        }

        public float y() {
            return this.delegate.y();
        }

        public ByteBuffer get(ByteBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public ByteBuffer get(int index, ByteBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public FloatBuffer get(FloatBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public FloatBuffer get(int index, FloatBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public Vector2f sub(Vector2fc v, Vector2f dest) {
            return this.delegate.sub(v, dest);
        }

        public Vector2f sub(float x, float y, Vector2f dest) {
            return this.delegate.sub(x, y, dest);
        }

        public float dot(Vector2fc v) {
            return this.delegate.dot(v);
        }

        public float angle(Vector2fc v) {
            return this.delegate.angle(v);
        }

        public float length() {
            return this.delegate.length();
        }

        public float lengthSquared() {
            return this.delegate.lengthSquared();
        }

        public float distance(Vector2fc v) {
            return this.delegate.distance(v);
        }

        public float distanceSquared(Vector2fc v) {
            return this.delegate.distanceSquared(v);
        }

        public float distance(float x, float y) {
            return this.delegate.distance(x, y);
        }

        public float distanceSquared(float x, float y) {
            return this.delegate.distanceSquared(x, y);
        }

        public Vector2f normalize(Vector2f dest) {
            return this.delegate.normalize(dest);
        }

        public Vector2f add(Vector2fc v, Vector2f dest) {
            return this.delegate.add(v, dest);
        }

        public Vector2f add(float x, float y, Vector2f dest) {
            return this.delegate.add(x, y, dest);
        }

        public Vector2f negate(Vector2f dest) {
            return this.delegate.negate(dest);
        }

        public Vector2f mul(float scalar, Vector2f dest) {
            return this.delegate.mul(scalar, dest);
        }

        public Vector2f mul(float x, float y, Vector2f dest) {
            return this.delegate.mul(x, y, dest);
        }

        public Vector2f mul(Vector2fc v, Vector2f dest) {
            return this.delegate.mul(v, dest);
        }

        public Vector2f lerp(Vector2fc other, float t, Vector2f dest) {
            return this.delegate.lerp(other, t, dest);
        }

        public Vector2f fma(Vector2fc a, Vector2fc b, Vector2f dest) {
            return this.delegate.fma(a, b, dest);
        }

        public Vector2f fma(float a, Vector2fc b, Vector2f dest) {
            return this.delegate.fma(a, b, dest);
        }
    }
}

