/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.renderer;

import erogenousbeef.bigreactors.client.ClientReactorFuelRodsLayout;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorFuelRod;
import erogenousbeef.bigreactors.init.BrFluids;
import it.zerono.mods.zerocore.lib.BlockFacings;
import it.zerono.mods.zerocore.lib.client.render.CachedRender;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.math.Colour;
import it.zerono.mods.zerocore.lib.math.Cuboid;
import it.zerono.mods.zerocore.lib.math.LightMap;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RendererReactorFuelRod
extends TileEntitySpecialRenderer<TileEntityReactorFuelRod> {
    private static final Cuboid FULL_VERTICAL_CUBE = new Cuboid(0.005, 0.0, 0.005, 0.995, 1.0, 0.995);

    public void render(TileEntityReactorFuelRod rod, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (rod.isOccluded()) {
            return;
        }
        MultiblockReactor reactor = rod.getReactorController();
        if (null == reactor || !reactor.isAssembled() || reactor.isInteriorInvisible()) {
            return;
        }
        ClientReactorFuelRodsLayout layout = (ClientReactorFuelRodsLayout)reactor.getFuelRodsLayout();
        BlockPos rodPosition = rod.getWorldPosition();
        if (EnumFacing.Plane.VERTICAL == layout.getAxis().func_176716_d()) {
            ClientReactorFuelRodsLayout.FuelRodFluidStatus fluidStatus;
            int rodIndex = rodPosition.func_177956_o() - reactor.getMinimumCoord().func_177956_o() - 1;
            ClientReactorFuelRodsLayout.FuelData rodData = layout.getFuelData(rodIndex);
            ClientReactorFuelRodsLayout.FuelRodFluidStatus fuelRodFluidStatus = fluidStatus = null != rodData ? rodData.getFluidStatus() : ClientReactorFuelRodsLayout.FuelRodFluidStatus.Empty;
            if (ClientReactorFuelRodsLayout.FuelRodFluidStatus.Empty == fluidStatus) {
                return;
            }
            if (ClientReactorFuelRodsLayout.FuelRodFluidStatus.Mixed == fluidStatus) {
                BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                float offset = MathHelper.func_76126_a((float)(((float)this.func_178459_a().func_82737_E() + partialTicks) * 0.1f)) * 0.01f;
                LightMap lightMap = this.getFuelLightMap(rodPosition);
                float wasteHeight = rodData.getWasteHeight() + offset;
                float fuelHeight = rodData.getFuelHeight() - offset;
                Cuboid cuboid = new Cuboid(0.005, 0.0, 0.005, 0.995, Math.min((double)wasteHeight, 1.0), 0.995);
                ModRenderHelper.bufferFluidCube((BufferBuilder)vertexBuffer, (Cuboid)cuboid, (BlockFacings)BlockFacings.HORIZONTAL, (Colour)layout.getWasteColor(), (LightMap)lightMap, (Fluid)BrFluids.fluidFuelColumn);
                BlockFacings visibleFaces = BlockFacings.HORIZONTAL.set(EnumFacing.UP, layout.getRodLength() - 1 == rodIndex || rodData.getFuelAmount() + (float)(4000 * rodIndex) >= layout.getFuelQuota());
                cuboid.MIN.Y = Math.max((double)wasteHeight, 0.0);
                cuboid.MAX.Y = Math.min((double)(fuelHeight + wasteHeight), 1.0);
                ModRenderHelper.bufferFluidCube((BufferBuilder)vertexBuffer, (Cuboid)cuboid, (BlockFacings)visibleFaces, (Colour)layout.getFuelColor(), (LightMap)lightMap, (Fluid)BrFluids.fluidFuelColumn);
                RenderHelper.func_74518_a();
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                this.func_147499_a(TextureMap.field_110575_b);
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
                RenderHelper.func_74519_b();
                return;
            }
            CachedRender render = layout.getCachedRender(fluidStatus);
            if (null == render) {
                switch (fluidStatus) {
                    default: {
                        render = new FuelRodCachedRender(BlockFacings.HORIZONTAL, FULL_VERTICAL_CUBE, ClientReactorFuelRodsLayout.FuelRodFluidStatus.FullFuelOnly == fluidStatus ? layout.getFuelColor() : layout.getWasteColor(), this.getFuelLightMap(rodPosition));
                        break;
                    }
                    case FuelOnly: 
                    case WasteOnly: {
                        float height = ClientReactorFuelRodsLayout.FuelRodFluidStatus.FuelOnly == fluidStatus ? rodData.getFuelHeight() : rodData.getWasteHeight();
                        render = new FuelRodCachedRender(BlockFacings.ALL.set(EnumFacing.DOWN, false).set(EnumFacing.UP, 1.0 != (double)height), new Cuboid(0.005, 0.0, 0.005, 0.995, (double)height, 0.995), ClientReactorFuelRodsLayout.FuelRodFluidStatus.FuelOnly == fluidStatus ? layout.getFuelColor() : layout.getWasteColor(), this.getFuelLightMap(rodPosition));
                    }
                }
                layout.setChachedRender(fluidStatus, render);
            }
            render.paint(x, y, z);
        } else {
            ClientReactorFuelRodsLayout.FuelRodFluidStatus fluidStatus;
            double z2;
            double z1;
            double x2;
            double x1;
            EnumFacing.Axis axis = layout.getAxis();
            if (EnumFacing.Axis.X == axis) {
                x1 = 0.0;
                x2 = 1.0;
                z1 = 0.005;
                z2 = 0.995;
            } else {
                x1 = 0.005;
                x2 = 0.995;
                z1 = 0.0;
                z2 = 1.0;
            }
            ClientReactorFuelRodsLayout.FuelData rodData = layout.getFuelData(0);
            ClientReactorFuelRodsLayout.FuelRodFluidStatus fuelRodFluidStatus = fluidStatus = null != rodData ? rodData.getFluidStatus() : ClientReactorFuelRodsLayout.FuelRodFluidStatus.Empty;
            if (ClientReactorFuelRodsLayout.FuelRodFluidStatus.Empty == fluidStatus) {
                return;
            }
            if (ClientReactorFuelRodsLayout.FuelRodFluidStatus.Mixed == fluidStatus) {
                BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                float offset = MathHelper.func_76126_a((float)(((float)this.func_178459_a().func_82737_E() + partialTicks) * 0.1f)) * 0.01f;
                LightMap lightMap = this.getFuelLightMap(rodPosition);
                float wasteHeight = rodData.getWasteHeight() + offset;
                float fuelHeight = rodData.getFuelHeight() - offset;
                BlockFacings visibleFaces = BlockFacings.from((boolean)true, (boolean)false, (axis != EnumFacing.Axis.Z ? 1 : 0) != 0, (axis != EnumFacing.Axis.Z ? 1 : 0) != 0, (axis != EnumFacing.Axis.X ? 1 : 0) != 0, (axis != EnumFacing.Axis.X ? 1 : 0) != 0);
                Cuboid cuboid = new Cuboid(x1, 0.005, z1, x2, Math.min((double)wasteHeight, 0.995), z2);
                ModRenderHelper.bufferFluidCube((BufferBuilder)vertexBuffer, (Cuboid)cuboid, (BlockFacings)visibleFaces, (Colour)layout.getWasteColor(), (LightMap)lightMap, (Fluid)BrFluids.fluidFuelColumn);
                visibleFaces = visibleFaces.set(EnumFacing.DOWN, false).set(EnumFacing.UP, true);
                cuboid.MIN.Y = Math.max((double)wasteHeight, 0.0);
                cuboid.MAX.Y = Math.min((double)fuelHeight - 0.005, 0.995);
                ModRenderHelper.bufferFluidCube((BufferBuilder)vertexBuffer, (Cuboid)cuboid, (BlockFacings)visibleFaces, (Colour)layout.getFuelColor(), (LightMap)lightMap, (Fluid)BrFluids.fluidFuelColumn);
                RenderHelper.func_74518_a();
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                this.func_147499_a(TextureMap.field_110575_b);
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
                RenderHelper.func_74519_b();
                return;
            }
            CachedRender render = layout.getCachedRender(fluidStatus);
            BlockFacings visibleFaces = BlockFacings.from((boolean)true, (boolean)true, (axis != EnumFacing.Axis.Z ? 1 : 0) != 0, (axis != EnumFacing.Axis.Z ? 1 : 0) != 0, (axis != EnumFacing.Axis.X ? 1 : 0) != 0, (axis != EnumFacing.Axis.X ? 1 : 0) != 0);
            if (null == render) {
                switch (fluidStatus) {
                    default: {
                        render = new FuelRodCachedRender(visibleFaces, new Cuboid(x1, 0.005, z1, x2, 0.995, z2), ClientReactorFuelRodsLayout.FuelRodFluidStatus.FullFuelOnly == fluidStatus ? layout.getFuelColor() : layout.getWasteColor(), this.getFuelLightMap(rodPosition));
                        break;
                    }
                    case FuelOnly: 
                    case WasteOnly: {
                        Colour colour = ClientReactorFuelRodsLayout.FuelRodFluidStatus.FuelOnly == fluidStatus ? layout.getFuelColor() : layout.getWasteColor();
                        float height = ClientReactorFuelRodsLayout.FuelRodFluidStatus.FuelOnly == fluidStatus ? rodData.getFuelHeight() : rodData.getWasteHeight();
                        render = new FuelRodCachedRender(visibleFaces, new Cuboid(x1, 0.005, z1, x2, (double)height - 0.005, z2), colour, this.getFuelLightMap(rodPosition));
                    }
                }
                layout.setChachedRender(fluidStatus, render);
            }
            render.paint(x, y, z);
        }
    }

    private LightMap getFuelLightMap(@Nonnull BlockPos position) {
        return LightMap.fromCombinedLight((int)this.func_178459_a().func_175626_b(position, BrFluids.fluidFuelColumn.getLuminosity()));
    }

    private static class FuelRodCachedRender
    extends CachedRender {
        private final BlockFacings _visibleFaces;
        private final Cuboid _cuboid;
        private final Colour _colour;
        private final LightMap _lightMap;

        public FuelRodCachedRender(@Nonnull BlockFacings visibleFaces, @Nonnull Cuboid cuboid, Colour argbColour, @Nonnull LightMap lightMap) {
            this._visibleFaces = visibleFaces;
            this._cuboid = cuboid;
            this._colour = argbColour;
            this._lightMap = lightMap;
        }

        protected ResourceLocation getTexture() {
            return TextureMap.field_110575_b;
        }

        protected void buildRender() {
            ModRenderHelper.paintFluidCube((Cuboid)this._cuboid, (BlockFacings)this._visibleFaces, (Colour)this._colour, (LightMap)this._lightMap, (Fluid)BrFluids.fluidFuelColumn);
        }
    }
}

