/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.BitQueryResults;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitVisitor;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.api.StateCount;
import mod.chiselsandbits.api.VoxelStats;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitIterator;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.api.BitBrush;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BitAccess
implements IBitAccess {
    private final World world;
    private final BlockPos pos;
    private final VoxelBlob blob;
    private final VoxelBlob filler;
    private final Map<Integer, IBitBrush> brushes = new HashMap<Integer, IBitBrush>();

    public VoxelBlob getNativeBlob() {
        return this.blob;
    }

    public BitAccess(World worldIn, BlockPos pos, VoxelBlob blob, VoxelBlob filler) {
        this.world = worldIn;
        this.pos = pos;
        this.blob = blob;
        this.filler = filler;
    }

    @Override
    public IBitBrush getBitAt(int x, int y, int z) {
        return this.getBrushForState(this.blob.getSafe(x, y, z));
    }

    private IBitBrush getBrushForState(int state) {
        IBitBrush brush = this.brushes.get(state);
        if (brush == null) {
            brush = new BitBrush(state);
            this.brushes.put(state, brush);
        }
        return brush;
    }

    @Override
    public void setBitAt(int x, int y, int z, IBitBrush bit) throws APIExceptions.SpaceOccupied {
        int state = 0;
        if (bit instanceof BitBrush) {
            state = bit.getStateID();
        }
        if (this.filler.get(x &= 0xF, y &= 0xF, z &= 0xF) != 0) {
            throw new APIExceptions.SpaceOccupied();
        }
        this.blob.set(x, y, z, state);
    }

    @Override
    public void commitChanges(boolean triggerUpdates) {
        World w = this.world;
        BlockPos p = this.pos;
        if (w != null && p != null) {
            TileEntityBlockChiseled tile = ModUtil.getChiseledTileEntity(w, p, true);
            VoxelStats cb = this.blob.getVoxelStats();
            if (tile == null && BlockChiseled.replaceWithChisled(w, p, this.world.func_180495_p(p), cb.mostCommonState, false)) {
                tile = ModUtil.getChiseledTileEntity(w, p, true);
            }
            if (tile != null) {
                VoxelBlobStateReference before = tile.getBlobStateReference();
                tile.setBlob(this.blob, triggerUpdates);
                tile.finishUpdate();
                VoxelBlobStateReference after = tile.getBlobStateReference();
                UndoTracker.getInstance().add(w, p, before, after);
            }
        }
    }

    @Override
    public ItemStack getBitsAsItem(@Nullable EnumFacing side, @Nullable ItemType type, boolean crossWorld) {
        ItemStack stack;
        if (type == null) {
            return ModUtil.getEmptyStack();
        }
        VoxelStats cb = this.blob.getVoxelStats();
        if (cb.mostCommonState == 0) {
            return ModUtil.getEmptyStack();
        }
        NBTBlobConverter c = new NBTBlobConverter();
        c.setBlob(this.blob);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        c.writeChisleData(nbttagcompound, crossWorld);
        if (type == ItemType.CHISLED_BLOCK) {
            IBlockState state = ModUtil.getStateById(cb.mostCommonState);
            BlockChiseled blk = ChiselsAndBits.getBlocks().getConversion(state);
            if (blk == null) {
                return ModUtil.getEmptyStack();
            }
            stack = new ItemStack((Block)blk, 1);
            stack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        } else {
            switch (type) {
                case MIRROR_DESIGN: {
                    stack = ModUtil.makeStack(ChiselsAndBits.getItems().itemMirrorprint);
                    break;
                }
                case NEGATIVE_DESIGN: {
                    stack = ModUtil.makeStack(ChiselsAndBits.getItems().itemNegativeprint);
                    break;
                }
                case POSITIVE_DESIGN: {
                    stack = ModUtil.makeStack(ChiselsAndBits.getItems().itemPositiveprint);
                    break;
                }
                default: {
                    return ModUtil.getEmptyStack();
                }
            }
            stack.func_77982_d(nbttagcompound);
        }
        if (side != null) {
            ModUtil.setSide(stack, side);
        }
        return stack;
    }

    @Override
    public void visitBits(IBitVisitor visitor) {
        BitIterator bi = new BitIterator();
        IBitBrush brush = this.getBrushForState(0);
        while (bi.hasNext()) {
            IBitBrush after;
            if (bi.getNext(this.filler) != 0) continue;
            int stateID = bi.getNext(this.blob);
            if (stateID != brush.getStateID()) {
                brush = this.getBrushForState(stateID);
            }
            if (brush == (after = visitor.visitBit(bi.x, bi.y, bi.z, brush))) continue;
            if (after == null) {
                bi.setNext(this.blob, 0);
                continue;
            }
            bi.setNext(this.blob, after.getStateID());
        }
    }

    @Override
    public BitQueryResults queryBitRange(BlockPos a, BlockPos b) {
        int air = 0;
        int fluid = 0;
        int solid = 0;
        BitIterator bi = new BitIterator(a, b);
        while (bi.hasNext()) {
            int state = bi.getNext(this.blob);
            if (state == 0) {
                ++air;
                continue;
            }
            if (VoxelBlob.isFluid(state)) {
                ++fluid;
                continue;
            }
            ++solid;
        }
        return new BitQueryResults(air, solid, fluid);
    }

    @Override
    public boolean mirror(EnumFacing.Axis axis) {
        VoxelBlob blobMirrored = this.blob.mirror(axis);
        if (this.filler.canMerge(blobMirrored)) {
            this.blob.fill(blobMirrored);
            return true;
        }
        return false;
    }

    @Override
    public boolean rotate(EnumFacing.Axis axis, Rotation rotation) {
        VoxelBlob blobRotated = ModUtil.rotate(this.blob, axis, rotation);
        if (blobRotated != null && this.filler.canMerge(blobRotated)) {
            this.blob.fill(blobRotated);
            return true;
        }
        return false;
    }

    @Override
    public List<StateCount> getStateCounts() {
        return this.blob.getStateCounts();
    }

    @Override
    public VoxelStats getVoxelStats() {
        return this.blob.getVoxelStats();
    }
}

