/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.component;

import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.IRenderComponent;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.icon.provider.IModelIconProvider;
import net.malisis.core.renderer.model.MalisisModel;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class ModelComponent
implements IRenderComponent {
    protected ResourceLocation resourceLocation;
    protected MalisisModel model;
    protected RenderParameters renderParameters = new RenderParameters();
    protected IModelIconProvider modelIconProvider;
    protected IVisibilityProvider visibilityProvider;

    public ModelComponent(String modelName, IVisibilityProvider visibilityProvider) {
        this.resourceLocation = new ResourceLocation(modelName);
        this.visibilityProvider = visibilityProvider;
        this.loadModel();
    }

    public ModelComponent(String modelName) {
        this(modelName, null);
    }

    public void setIconProvider(IModelIconProvider iconProvider) {
        this.modelIconProvider = iconProvider;
    }

    @Override
    public void onComponentAdded(IComponentProvider provider) {
        IModelIconProvider mip = provider.getComponent(IModelIconProvider.class);
        if (mip != null) {
            this.setIconProvider(mip);
        }
    }

    protected void loadModel() {
        this.model = new MalisisModel(this.resourceLocation);
    }

    public MalisisModel getModel() {
        return this.model;
    }

    @Override
    public void render(Block block, MalisisRenderer<? extends TileEntity> renderer) {
        this.loadModel();
        this.model.resetState();
        if (renderer.getRenderType() != RenderType.ITEM) {
            this.model.rotate(DirectionalComponent.getDirection(renderer.getBlockState()));
        }
        for (String name : this.model.getShapeNames()) {
            if (this.visibilityProvider != null && !this.visibilityProvider.isVisible(renderer, name)) continue;
            if (this.modelIconProvider != null) {
                this.renderParameters.icon.set(this.modelIconProvider.getIcon(renderer, name));
            }
            this.model.render(renderer, name, this.renderParameters);
        }
    }

    public static interface IVisibilityProvider {
        public boolean isVisible(MalisisRenderer<? extends TileEntity> var1, String var2);
    }
}

