/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import cofh.thermalexpansion.util.managers.machine.BrewerManager;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import cofh.thermalexpansion.util.managers.machine.ChargerManager;
import cofh.thermalexpansion.util.managers.machine.CompactorManager;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import cofh.thermalexpansion.util.managers.machine.EnchanterManager;
import cofh.thermalexpansion.util.managers.machine.ExtruderManager;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import cofh.thermalexpansion.util.managers.machine.PrecipitatorManager;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import cofh.thermalfoundation.init.TFFluids;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidStack;

@RegPEIPlugin(modid="thermalexpansion")
public class PluginThermalExpansion
extends PEIPlugin {
    public PluginThermalExpansion(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        this.addMapper(new BrewerMapper());
        this.addMapper(new CentrifugeMapper());
        this.addMapper(new ChargerMapper());
        this.addMapper(new CompactorMapper());
        this.addMapper(new CrucibleMapper());
        this.addMapper(new EnchanterMapper());
        this.addMapper(new ExtruderMapper());
        this.addMapper(new FurnaceMapper());
        this.addMapper(new InsolatorMapper());
        this.addMapper(new PrecipitatorMapper());
        this.addMapper(new PulverizerMapper());
        this.addMapper(new RefineryMapper());
        this.addMapper(new SawmillMapper());
        this.addMapper(new SmelterMapper());
        this.addMapper(new TransposerMapper());
    }

    private class TransposerMapper
    extends PEIMapper {
        public TransposerMapper() {
            super("Transposer", "");
        }

        @Override
        public void setup() {
            for (TransposerManager.TransposerRecipe recipe : TransposerManager.getExtractRecipeList()) {
                this.addRecipe(recipe.getFluid(), recipe.getInput());
            }
            for (TransposerManager.TransposerRecipe recipe : TransposerManager.getFillRecipeList()) {
                this.addRecipe(recipe.getOutput(), recipe.getInput(), recipe.getFluid());
            }
        }
    }

    private class SmelterMapper
    extends PEIMapper {
        public SmelterMapper() {
            super("Smelter", "");
        }

        @Override
        public void setup() {
            for (SmelterManager.SmelterRecipe recipe : SmelterManager.getRecipeList()) {
                this.addRecipe(recipe.getPrimaryOutput(), recipe.getPrimaryInput(), recipe.getSecondaryInput());
            }
        }
    }

    private class SawmillMapper
    extends PEIMapper {
        public SawmillMapper() {
            super("Sawmill", "");
        }

        @Override
        public void setup() {
            for (SawmillManager.SawmillRecipe recipe : SawmillManager.getRecipeList()) {
                this.addRecipe(recipe.getPrimaryOutput(), recipe.getInput());
            }
        }
    }

    private class RefineryMapper
    extends PEIMapper {
        public RefineryMapper() {
            super("Refinery", "");
        }

        @Override
        public void setup() {
            for (RefineryManager.RefineryRecipe recipe : RefineryManager.getRecipeList()) {
                if (recipe.getChance() != 100) continue;
                this.addRecipe(recipe.getOutputItem(), recipe.getInput());
                this.addRecipe(recipe.getOutputFluid(), recipe.getInput());
            }
        }
    }

    private class PulverizerMapper
    extends PEIMapper {
        public PulverizerMapper() {
            super("Pulverizer", "");
        }

        @Override
        public void setup() {
            for (PulverizerManager.PulverizerRecipe recipe : PulverizerManager.getRecipeList()) {
                this.addRecipe(recipe.getPrimaryOutput(), recipe.getInput());
            }
        }
    }

    private class PrecipitatorMapper
    extends PEIMapper {
        public PrecipitatorMapper() {
            super("Precipitator", "");
        }

        @Override
        public void setup() {
            for (PrecipitatorManager.PrecipitatorRecipe recipe : PrecipitatorManager.getRecipeList()) {
                this.addRecipe(recipe.getOutput(), recipe.getInput());
            }
        }
    }

    private class InsolatorMapper
    extends PEIMapper {
        public InsolatorMapper() {
            super("Insolator", "");
        }

        @Override
        public void setup() {
            for (InsolatorManager.InsolatorRecipe recipe : InsolatorManager.getRecipeList()) {
                if (recipe.getType() == InsolatorManager.Type.TREE || recipe.hasFertilizer()) continue;
                this.addRecipe(recipe.getPrimaryOutput(), recipe.getPrimaryInput(), recipe.getSecondaryInput());
            }
        }
    }

    private class FurnaceMapper
    extends PEIMapper {
        public FurnaceMapper() {
            super("Furnace", "");
        }

        @Override
        public void setup() {
            for (FurnaceManager.FurnaceRecipe recipe : FurnaceManager.getRecipeList((boolean)false)) {
                this.addRecipe(recipe.getOutput(), recipe.getInput());
            }
            for (FurnaceManager.FurnaceRecipe recipe : FurnaceManager.getRecipeList((boolean)true)) {
                this.addRecipe(recipe.getOutput(), recipe.getInput());
                if (recipe.getCreosote() <= 0) continue;
                this.addRecipe(new FluidStack(TFFluids.fluidCreosote, recipe.getCreosote()), recipe.getInput());
            }
        }
    }

    private class ExtruderMapper
    extends PEIMapper {
        public ExtruderMapper() {
            super("Extruder", "");
        }

        private void addRecipe(ExtruderManager.ExtruderRecipe recipe) {
            this.addRecipe(recipe.getOutput(), recipe.getInputHot(), recipe.getInputCold());
        }

        @Override
        public void setup() {
            for (ExtruderManager.ExtruderRecipe recipe : ExtruderManager.getRecipeList((boolean)true)) {
                this.addRecipe(recipe);
            }
            for (ExtruderManager.ExtruderRecipe recipe : ExtruderManager.getRecipeList((boolean)false)) {
                this.addRecipe(recipe);
            }
        }
    }

    private class EnchanterMapper
    extends PEIMapper {
        public EnchanterMapper() {
            super("Enchanter", "");
        }

        @Override
        public void setup() {
            for (EnchanterManager.EnchanterRecipe recipe : EnchanterManager.getRecipeList()) {
                this.addRecipe(recipe.getOutput(), recipe.getPrimaryInput(), recipe.getSecondaryInput(), new FluidStack(TFFluids.fluidExperience, recipe.getExperience()));
            }
        }
    }

    private class CrucibleMapper
    extends PEIMapper {
        public CrucibleMapper() {
            super("Crucible", "");
        }

        @Override
        public void setup() {
            for (CrucibleManager.CrucibleRecipe recipe : CrucibleManager.getRecipeList()) {
                this.addRecipe(recipe.getOutput(), recipe.getInput());
            }
        }
    }

    private class CompactorMapper
    extends PEIMapper {
        public CompactorMapper() {
            super("Compactor", "");
        }

        @Override
        public void setup() {
            for (CompactorManager.Mode mode : CompactorManager.Mode.values()) {
                for (CompactorManager.CompactorRecipe recipe : CompactorManager.getRecipeList((CompactorManager.Mode)mode)) {
                    this.addRecipe(recipe.getOutput(), recipe.getInput());
                }
            }
        }
    }

    private class ChargerMapper
    extends PEIMapper {
        public ChargerMapper() {
            super("Charger", "");
        }

        @Override
        public void setup() {
            for (ChargerManager.ChargerRecipe recipe : ChargerManager.getRecipeList()) {
                this.addRecipe(recipe.getOutput(), recipe.getInput());
            }
        }
    }

    private class CentrifugeMapper
    extends PEIMapper {
        public CentrifugeMapper() {
            super("Centrifuge", "");
        }

        @Override
        public void setup() {
            for (CentrifugeManager.CentrifugeRecipe recipe : CentrifugeManager.getRecipeList()) {
                if (recipe.getFluid() == null) continue;
                this.addRecipe(recipe.getFluid(), recipe.getInput());
            }
        }
    }

    private class BrewerMapper
    extends PEIMapper {
        public BrewerMapper() {
            super("Brewer", "");
        }

        @Override
        public void setup() {
            for (BrewerManager.BrewerRecipe recipe : BrewerManager.getRecipeList()) {
                this.addRecipe(recipe.getOutputFluid(), recipe.getInput(), recipe.getInputFluid());
            }
        }
    }
}

