/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IThaumcraftRecipe;
import thaumcraft.api.crafting.InfusionRecipe;

@RegPEIPlugin(modid="thaumcraft")
public class PluginThaumcraft
extends PEIPlugin {
    private final Map<Aspect, Object> ASPECT_MAP = new HashMap<Aspect, Object>();
    private final Set<IArcaneRecipe> ARCANE_RECIPES = new HashSet<IArcaneRecipe>();
    private final Set<CrucibleRecipe> CRUCIBLE_RECIPES = new HashSet<CrucibleRecipe>();
    private final Set<InfusionRecipe> INFUSION_RECIPES = new HashSet<InfusionRecipe>();

    public PluginThaumcraft(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        for (Aspect aspect : Aspect.aspects.values()) {
            Object obj = new Object();
            this.addEMC("aspect_" + aspect.getName(), obj, 10);
            this.ASPECT_MAP.put(aspect, obj);
        }
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!(recipe instanceof IArcaneRecipe)) continue;
            this.ARCANE_RECIPES.add((IArcaneRecipe)recipe);
        }
        for (IThaumcraftRecipe recipe : ThaumcraftApi.getCraftingRecipes().values()) {
            if (recipe instanceof IArcaneRecipe) {
                this.ARCANE_RECIPES.add((IArcaneRecipe)recipe);
            }
            if (recipe instanceof CrucibleRecipe) {
                this.CRUCIBLE_RECIPES.add((CrucibleRecipe)recipe);
            }
            if (!(recipe instanceof InfusionRecipe)) continue;
            this.INFUSION_RECIPES.add((InfusionRecipe)recipe);
        }
        this.addMapper(new ArcaneMapper());
        this.addMapper(new CrucibleMapper());
        this.addMapper(new InfusionMapper());
    }

    private class InfusionMapper
    extends ThaumcraftMapper {
        public InfusionMapper() {
            super("Infusion", "");
        }

        @Override
        public void setup() {
            for (InfusionRecipe recipe : PluginThaumcraft.this.INFUSION_RECIPES) {
                this.addRecipe(recipe.getRecipeOutput(), (Object)recipe.getRecipeInput(), recipe.getAspects());
            }
            PluginThaumcraft.this.INFUSION_RECIPES.clear();
        }
    }

    private class CrucibleMapper
    extends ThaumcraftMapper {
        public CrucibleMapper() {
            super("Crucible", "");
        }

        @Override
        public void setup() {
            for (CrucibleRecipe recipe : PluginThaumcraft.this.CRUCIBLE_RECIPES) {
                this.addRecipe((Object)recipe.getRecipeOutput(), (Object)recipe.getCatalyst(), recipe.getAspects());
            }
            PluginThaumcraft.this.CRUCIBLE_RECIPES.clear();
        }
    }

    private class ArcaneMapper
    extends ThaumcraftMapper {
        public ArcaneMapper() {
            super("Arcane", "");
        }

        @Override
        public void setup() {
            for (IArcaneRecipe recipe : PluginThaumcraft.this.ARCANE_RECIPES) {
                this.addRecipe((Object)recipe.func_77571_b(), (Object)recipe.func_192400_c(), recipe.getCrystals());
            }
            PluginThaumcraft.this.ARCANE_RECIPES.clear();
        }
    }

    private abstract class ThaumcraftMapper
    extends PEIMapper {
        public ThaumcraftMapper(String name, String description) {
            super(name, description);
        }

        protected void addRecipe(Object recipe_output, Object recipe_input, AspectList recipe_aspects) {
            if (recipe_output == null || recipe_input == null || recipe_aspects == null) {
                return;
            }
            Object output = null;
            if (!(recipe_output instanceof ItemStack || recipe_output instanceof Item || recipe_output instanceof Block)) {
                return;
            }
            output = recipe_output;
            IngredientMap ingredients = new IngredientMap();
            if (recipe_input instanceof ItemStack || recipe_input instanceof Item || recipe_input instanceof Block) {
                ingredients.addIngredient(recipe_input, 1);
            } else if (recipe_input instanceof List) {
                for (Map.Entry in : (List)recipe_input) {
                    if (!(in instanceof ItemStack) && !(in instanceof Item) && !(in instanceof Block)) continue;
                    ingredients.addIngredient(in, 1);
                }
            }
            for (Map.Entry entry : recipe_aspects.aspects.entrySet()) {
                ingredients.addIngredient(PluginThaumcraft.this.ASPECT_MAP.get(entry.getKey()), ((Integer)entry.getValue()).intValue());
            }
            if (output instanceof ItemStack) {
                this.addConversion((ItemStack)output, (Map<Object, Integer>)ingredients.getMap());
            } else {
                this.addConversion(1, output, ingredients.getMap());
            }
        }
    }
}

