/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import com.tagnumelite.projecteintegration.api.utils.ConfigHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.recipes.RecipeTranslator;

@RegPEIPlugin(modid="reborncore")
public class PluginRebornCore
extends PEIPlugin {
    public PluginRebornCore(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        this.addMapper(new RebornCoreMapper());
    }

    private class RebornCoreMapper
    extends PEIMapper {
        private final Map<String, Boolean> RECIPE_CFG_MAP;

        public RebornCoreMapper() {
            super("Reborn Core", "");
            this.RECIPE_CFG_MAP = new HashMap<String, Boolean>();
        }

        @Override
        public void setup() {
            for (IBaseRecipeType recipe : RecipeHandler.recipeList) {
                List inputs;
                List outputs;
                String recipe_name = recipe.getRecipeName();
                if (this.RECIPE_CFG_MAP.containsKey(recipe_name)) {
                    if (!this.RECIPE_CFG_MAP.get(recipe_name).booleanValue()) {
                        continue;
                    }
                } else {
                    this.RECIPE_CFG_MAP.put(recipe_name, PluginRebornCore.this.config.getBoolean(ConfigHelper.getConversionName(recipe_name), PluginRebornCore.this.category, true, "Enable conversions for machine " + recipe_name));
                }
                if ((outputs = recipe.getOutputs()) == null || outputs.isEmpty() || (inputs = recipe.getInputs()) == null || inputs.isEmpty()) continue;
                IngredientMap ingredients = new IngredientMap();
                inputs.forEach(input -> {
                    ItemStack item = RecipeTranslator.getStackFromObject((Object)input);
                    ingredients.addIngredient((Object)item, item.func_190916_E());
                });
                Map map = ingredients.getMap();
                if (map == null || map.isEmpty()) continue;
                outputs.forEach(output -> {
                    if (output != null && !output.func_190926_b()) {
                        this.addConversion((ItemStack)output, (Map<Object, Integer>)map);
                    }
                });
            }
            this.RECIPE_CFG_MAP.clear();
        }
    }
}

