/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.pam.harvestcraft.item.GrinderRecipes;
import com.pam.harvestcraft.item.PresserRecipes;
import com.pam.harvestcraft.item.WaterFilterRecipes;
import com.pam.harvestcraft.tileentities.MarketData;
import com.pam.harvestcraft.tileentities.MarketItems;
import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import com.tagnumelite.projecteintegration.api.utils.Utils;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.reflect.FieldUtils;

@RegPEIPlugin(modid="harvestcraft")
public class PluginPamsHarvestCraft
extends PEIPlugin {
    public PluginPamsHarvestCraft(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        this.addEMC("listAllfruit", 128, "");
        this.addEMC("listAllgrain", 24, "");
        this.addEMC("listAllmeatraw", 64, "");
        this.addEMC("listAllveggie", 64, "");
        this.addEMC("listAllnut", 64, "");
        this.addEMC("listAllgreenveggie", 64, "");
        this.addEMC("listAllseed", 16, "");
        this.addEMC("listAllberry", 16, "");
        this.addMapper(new MarketMapper());
        this.addMapper(new MachineMapper("Grinder", GrinderRecipes.class, "grindingList"));
        this.addMapper(new MachineMapper("Presser", PresserRecipes.class, "pressingList"));
        this.addMapper(new MachineMapper("Water Filter", WaterFilterRecipes.class, "waterfilterList"));
    }

    private class MachineMapper
    extends PEIMapper {
        private final Class<?> machine;
        private final String field;

        public MachineMapper(String name, Class<?> machine, String field) {
            super(name, "This may not work 100% of the time because of hacky methods used to fetch the recipes!");
            this.machine = machine;
            this.field = field;
        }

        @Override
        public void setup() {
            try {
                for (Map.Entry entr : ((Map)FieldUtils.readStaticField(this.machine, (String)this.field, (boolean)true)).entrySet()) {
                    ItemStack[] outputs = (ItemStack[])entr.getValue();
                    ItemStack input = (ItemStack)entr.getKey();
                    if (outputs.length == 2 && Utils.isSameItem(outputs[0], outputs[1])) {
                        ItemStack output = outputs[0].func_77946_l();
                        output.func_190920_e(outputs[0].func_190916_E() + outputs[1].func_190916_E());
                        this.addRecipe(output, input.func_77946_l());
                        continue;
                    }
                    for (ItemStack output : outputs) {
                        this.addRecipe(output, input);
                    }
                }
            }
            catch (Exception e) {
                PEIApi.LOG.error("Failed to get HarvestCraft machine '{}' recipes: {}", (Object)this.name, (Object)e);
            }
        }
    }

    private class MarketMapper
    extends PEIMapper {
        protected MarketMapper() {
            super("Market", "", true);
        }

        @Override
        public void setup() {
            for (int i = 0; i < MarketItems.getSize(); ++i) {
                MarketData data = MarketItems.getData((int)i);
                ItemStack input = data.getCurrency();
                input.func_190920_e(data.getPrice());
                this.addRecipe(data.getItem(), input);
            }
        }
    }
}

