/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.google.common.collect.ImmutableMap;
import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.IngredientMap;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidStack;

@RegPEIPlugin(modid="nuclearcraft")
public class PluginNuclearCraft
extends PEIPlugin {
    public PluginNuclearCraft(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        for (NCRecipes.Type recipe_type : NCRecipes.Type.values()) {
            this.addMapper(new NCRecipeMapper(recipe_type));
        }
    }

    private class NCRecipeMapper
    extends PEIMapper {
        private NCRecipes.Type recipe_type;

        public NCRecipeMapper(NCRecipes.Type recipe_type) {
            super(recipe_type.toString(), "Enable Recipe mapper for this machine?");
            this.recipe_type = recipe_type;
        }

        private Object getObjectFromItemIngredient(IItemIngredient item) {
            Object obj = new Object();
            for (ItemStack input : item.getInputStackList()) {
                this.addConversion(1, obj, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)input.func_190916_E()));
            }
            return obj;
        }

        private Object getObjectFromFluidIngredient(IFluidIngredient fluid) {
            Object obj = new Object();
            for (FluidStack input : fluid.getInputStackList()) {
                this.addConversion(1, obj, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)input.amount));
            }
            return obj;
        }

        @Override
        public void setup() {
            ProcessorRecipeHandler recipe_handler = this.recipe_type.getRecipeHandler();
            for (ProcessorRecipe recipe : recipe_handler.getRecipes()) {
                int fluid_input_size = recipe_handler.fluidInputSize;
                int fluid_output_size = recipe_handler.fluidOutputSize;
                int item_input_size = recipe_handler.itemInputSize;
                int item_output_size = recipe_handler.itemOutputSize;
                List item_inputs = recipe.itemIngredients();
                List fluid_inputs = recipe.fluidIngredients();
                List item_outputs = recipe.itemProducts();
                List fluid_outputs = recipe.fluidProducts();
                if (item_output_size == 0 && fluid_output_size == 0 || fluid_input_size == 0 && item_input_size == 0 || item_outputs.size() != item_output_size || fluid_outputs.size() != fluid_output_size || item_inputs.size() != item_input_size || fluid_inputs.size() != fluid_input_size) {
                    PEIntegration.LOG.warn("Invalid Recipe: {}", (Object)recipe_handler.getRecipeName());
                    continue;
                }
                IngredientMap ingredients = new IngredientMap();
                for (IItemIngredient input : item_inputs) {
                    ingredients.addIngredient(this.getObjectFromItemIngredient(input), input.getMaxStackSize(0));
                }
                for (IItemIngredient input : fluid_inputs) {
                    ingredients.addIngredient(this.getObjectFromFluidIngredient((IFluidIngredient)input), input.getMaxStackSize(0));
                }
                for (IItemIngredient output : item_outputs) {
                    for (ItemStack output_item : output.getInputStackList()) {
                        if (output_item == null || output_item.func_190926_b()) continue;
                        this.addConversion(output_item, (Map<Object, Integer>)ingredients.getMap());
                    }
                }
                for (IItemIngredient output : fluid_outputs) {
                    for (FluidStack output_fluid : output.getInputStackList()) {
                        if (output_fluid == null || output_fluid.amount == 0) continue;
                        this.addConversion(output_fluid, (Map<Object, Integer>)ingredients.getMap());
                    }
                }
            }
        }
    }
}

