/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementFluid;
import hellfirepvp.modularmachinery.common.crafting.requirements.RequirementItem;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import java.util.ArrayList;
import java.util.Map;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidStack;

@RegPEIPlugin(modid="modularmachinery")
public class PluginModularMachinery
extends PEIPlugin {
    public PluginModularMachinery(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        for (DynamicMachine machine : MachineRegistry.getRegistry()) {
            this.addMapper(new MachineMapper(machine));
        }
    }

    private class MachineMapper
    extends PEIMapper {
        private final DynamicMachine machine;

        public MachineMapper(DynamicMachine machine) {
            super(machine.getLocalizedName(), "");
            this.machine = machine;
        }

        @Override
        public void setup() {
            for (MachineRecipe recipe : this.machine.getAvailableRecipes()) {
                IngredientMap ingredients = new IngredientMap();
                ArrayList<ItemStack> item_outputs = new ArrayList<ItemStack>();
                ArrayList<FluidStack> fluid_outputs = new ArrayList<FluidStack>();
                for (ComponentRequirement req : recipe.getCraftingRequirements()) {
                    if (req instanceof RequirementEnergy) continue;
                    if (req instanceof RequirementItem) {
                        RequirementItem requirementItem = (RequirementItem)req;
                        switch (requirementItem.getActionType()) {
                            case INPUT: {
                                if (requirementItem.requirementType == RequirementItem.ItemRequirementType.ITEMSTACKS) {
                                    if (requirementItem.required == null || requirementItem.required == ItemStack.field_190927_a) break;
                                    ingredients.addIngredient((Object)requirementItem.required, requirementItem.required.func_190916_E());
                                    break;
                                }
                                if (requirementItem.requirementType != RequirementItem.ItemRequirementType.OREDICT || requirementItem.oreDictName == null || requirementItem.oreDictName == "" || requirementItem.oreDictItemAmount <= 0) break;
                                ingredients.addIngredient((Object)requirementItem.oreDictName, requirementItem.oreDictItemAmount);
                                break;
                            }
                            case OUTPUT: {
                                if (requirementItem.requirementType != RequirementItem.ItemRequirementType.ITEMSTACKS || requirementItem.required == null || requirementItem.required == ItemStack.field_190927_a) break;
                                item_outputs.add(requirementItem.required);
                            }
                        }
                    } else if (req instanceof RequirementFluid) {
                        RequirementFluid requirementFluid = (RequirementFluid)req;
                        FluidStack fluid = requirementFluid.required.asFluidStack();
                        switch (requirementFluid.getActionType()) {
                            case INPUT: {
                                if (fluid == null || fluid.amount <= 0) break;
                                ingredients.addIngredient((Object)fluid, fluid.amount);
                                break;
                            }
                            case OUTPUT: {
                                if (fluid == null || fluid.amount <= 0) break;
                                fluid_outputs.add(fluid);
                            }
                        }
                    }
                }
                Map map = ingredients.getMap();
                for (ItemStack itemStack : item_outputs) {
                    this.addConversion(itemStack, (Map<Object, Integer>)map);
                }
                for (FluidStack fluidStack : fluid_outputs) {
                    this.addConversion(fluidStack, (Map<Object, Integer>)map);
                }
            }
        }
    }
}

