/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import net.minecraftforge.common.config.Configuration;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.RecipeRegistry;

@RegPEIPlugin(modid="embers")
public class PluginEmbers
extends PEIPlugin {
    public PluginEmbers(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        this.addMapper(new AlchemyMapper());
        this.addMapper(new MeltingMapper());
        this.addMapper(new MixingMapper());
        this.addMapper(new StamperMapper());
    }

    private class StamperMapper
    extends PEIMapper {
        public StamperMapper() {
            super("Stamper", "");
        }

        @Override
        public void setup() {
            for (ItemStampingRecipe recipe : RecipeRegistry.stampingRecipes) {
                this.addRecipe(recipe.result.func_77946_l(), recipe.getStack(), recipe.getFluid());
            }
        }
    }

    private class MixingMapper
    extends PEIMapper {
        public MixingMapper() {
            super("Mixing", "");
        }

        @Override
        public void setup() {
            for (FluidMixingRecipe recipe : RecipeRegistry.mixingRecipes) {
                this.addRecipe(recipe.output.copy(), recipe.inputs.toArray());
            }
        }
    }

    private class MeltingMapper
    extends PEIMapper {
        public MeltingMapper() {
            super("Melting", "");
        }

        @Override
        public void setup() {
            for (ItemMeltingRecipe recipe : RecipeRegistry.meltingRecipes) {
                this.addRecipe(recipe.getFluid(), recipe.getStack());
            }
        }
    }

    private class AlchemyMapper
    extends PEIMapper {
        public AlchemyMapper() {
            super("Alchemy", "");
        }

        @Override
        public void setup() {
            for (AlchemyRecipe recipe : RecipeRegistry.alchemyRecipes) {
                this.addRecipe(recipe.result.func_77946_l(), recipe.centerInput, recipe.inputs.toArray());
            }
        }
    }
}

