/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.google.common.collect.ImmutableMap;
import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import java.util.List;
import java.util.Map;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.api.recipe.RecipeManaInfusion;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.api.recipe.RecipePureDaisy;
import vazkii.botania.api.recipe.RecipeRuneAltar;

@RegPEIPlugin(modid="botania")
public class PluginBotania
extends PEIPlugin {
    private final Object mana = new Object();
    private final boolean add_emc_to_mana;

    public PluginBotania(String modid, Configuration config) {
        super(modid, config);
        this.add_emc_to_mana = config.getBoolean("add_emc_to_mana", this.category, true, "Should mana have an EMC?");
    }

    @Override
    public void setup() {
        this.addEMC("mana", this.mana, 1, "NOTE: This is effectively a multiplier. Calculation is {EMC VALUE} * {MANA REQUIED}");
        this.addMapper(new ElvenTradeMapper());
        this.addMapper(new PetalMapper());
        this.addMapper(new PureDaisyMapper());
        this.addMapper(new ManaInfusionMapper());
        this.addMapper(new RuneAlterMapper());
    }

    private static Map<Object, Integer> createMapFromList(List<Object> list) {
        if (list.isEmpty()) {
            return null;
        }
        IngredientMap map = new IngredientMap();
        list.forEach(item -> {
            if (item instanceof ItemStack) {
                map.addIngredient(item, ((ItemStack)item).func_190916_E());
            } else if (item instanceof String) {
                map.addIngredient(item, 1);
            }
        });
        return map.getMap();
    }

    private static final ItemStack getItemStackFromBlockState(IBlockState state) {
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
    }

    private class RuneAlterMapper
    extends PEIMapper {
        public RuneAlterMapper() {
            super("Rune Alter", "");
        }

        @Override
        public void setup() {
            for (RecipeRuneAltar recipe : BotaniaAPI.runeAltarRecipes) {
                List inputs;
                ItemStack output = recipe.getOutput();
                if (output == null || output.func_190926_b() || (inputs = recipe.getInputs()) == null || inputs.isEmpty()) continue;
                int manaConsumption = recipe.getManaUsage();
                IngredientMap ingredients = new IngredientMap();
                inputs.forEach(input -> {
                    if (input instanceof ItemStack) {
                        ingredients.addIngredient(input, ((ItemStack)input).func_190916_E());
                    } else {
                        ingredients.addIngredient(input, 1);
                    }
                });
                if (PluginBotania.this.add_emc_to_mana) {
                    ingredients.addIngredient(PluginBotania.this.mana, manaConsumption);
                }
                this.addConversion(output, (Map<Object, Integer>)ingredients.getMap());
            }
        }
    }

    private class ManaInfusionMapper
    extends PEIMapper {
        public ManaInfusionMapper() {
            super("Mana Infusion", "");
        }

        @Override
        public void setup() {
            for (RecipeManaInfusion recipe : BotaniaAPI.manaInfusionRecipes) {
                Object input;
                ItemStack output = recipe.getOutput();
                if (output == null || output.func_190926_b() || !((input = recipe.getInput()) instanceof ItemStack) && !(input instanceof String)) continue;
                int manaConsumption = recipe.getManaToConsume();
                if (PluginBotania.this.add_emc_to_mana) {
                    this.addConversion(output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)1, (Object)PluginBotania.this.mana, (Object)manaConsumption));
                    continue;
                }
                this.addConversion(output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)1));
            }
        }
    }

    private class PureDaisyMapper
    extends PEIMapper {
        public PureDaisyMapper() {
            super("Pure Daisy", "");
        }

        @Override
        public void setup() {
            for (RecipePureDaisy recipe : BotaniaAPI.pureDaisyRecipes) {
                Object input;
                ItemStack output = PluginBotania.getItemStackFromBlockState(recipe.getOutputState());
                if (output == null || output.func_190926_b() || (input = recipe.getInput()) == null) continue;
                if (input instanceof IBlockState) {
                    if ((input = PluginBotania.getItemStackFromBlockState((IBlockState)input)) == null) {
                        PEIApi.LOG.info("ItemStack is null when fetching from BlockState: {}", input);
                        continue;
                    }
                } else if (input instanceof Block && input instanceof BlockLiquid) continue;
                this.addConversion(output, (Map<Object, Integer>)ImmutableMap.of((Object)input, (Object)1));
            }
        }
    }

    private class PetalMapper
    extends PEIMapper {
        public PetalMapper() {
            super("Petal", "");
        }

        @Override
        public void setup() {
            for (RecipePetals recipe : BotaniaAPI.petalRecipes) {
                List inputs;
                ItemStack output = recipe.getOutput();
                if (output == null || output.func_190926_b() || (inputs = recipe.getInputs()).isEmpty()) continue;
                this.addConversion(output.func_190916_E(), output, PluginBotania.createMapFromList(inputs));
            }
        }
    }

    private class ElvenTradeMapper
    extends PEIMapper {
        public ElvenTradeMapper() {
            super("Elven Trade", "");
        }

        @Override
        public void setup() {
            for (RecipeElvenTrade recipe : BotaniaAPI.elvenTradeRecipes) {
                List inputs;
                List outputs = recipe.getOutputs();
                if (outputs.isEmpty() || (inputs = recipe.getInputs()).isEmpty()) continue;
                outputs.forEach(output -> this.addConversion(output.func_190916_E(), output, PluginBotania.createMapFromList(inputs)));
            }
        }
    }
}

