/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import appeng.api.AEApi;
import appeng.api.features.IGrinderRecipe;
import appeng.api.features.IInscriberRecipe;
import appeng.api.features.InscriberProcessType;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import java.util.Optional;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

@RegPEIPlugin(modid="appliedenergistics2")
public class PluginAppliedEnergistics
extends PEIPlugin {
    public PluginAppliedEnergistics(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        this.addMapper(new InscriberMapper());
        this.addMapper(new GrindstoneMapper());
    }

    private class GrindstoneMapper
    extends PEIMapper {
        public GrindstoneMapper() {
            super("Grindstone", "");
        }

        @Override
        public void setup() {
            for (IGrinderRecipe recipe : AEApi.instance().registries().grinder().getRecipes()) {
                this.addRecipe(recipe.getOutput(), recipe.getInput());
            }
        }
    }

    private class InscriberMapper
    extends PEIMapper {
        public InscriberMapper() {
            super("Inscriber", "");
        }

        @Override
        public void setup() {
            for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
                ItemStack input;
                ItemStack output = recipe.getOutput();
                if (output == null || output.func_190926_b() || (input = (ItemStack)recipe.getInputs().get(0)) == null || input.func_190926_b()) continue;
                IngredientMap ingredients = new IngredientMap();
                ingredients.addIngredient((Object)input, input.func_190916_E());
                if (recipe.getProcessType() == InscriberProcessType.PRESS) {
                    Optional input_bottom;
                    Optional input_top = recipe.getTopOptional();
                    if (input_top.isPresent() && input_top.get() != ItemStack.field_190927_a) {
                        ingredients.addIngredient(input_top.get(), ((ItemStack)input_top.get()).func_190916_E());
                    }
                    if ((input_bottom = recipe.getBottomOptional()).isPresent() && input_bottom.get() != ItemStack.field_190927_a) {
                        ingredients.addIngredient(input_bottom.get(), ((ItemStack)input_bottom.get()).func_190916_E());
                    }
                }
                this.addConversion(output.func_190916_E(), output, ingredients.getMap());
            }
        }
    }
}

