/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.compat;

import com.tagnumelite.projecteintegration.PEIntegration;
import com.tagnumelite.projecteintegration.api.PEIApi;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.projecteintegration.PEI")
public class CompatCraftTweaker {
    @ZenMethod
    public static void addConversion(IItemStack output, IIngredient[] input) {
        PEIntegration.LOG.info("Testing CraftTweaker Support: {}", (Object)output.getDisplayName());
        CraftTweakerAPI.apply((IAction)new AddConversion(output, input));
    }

    @ZenMethod
    public static void addConversion(ILiquidStack output, IIngredient[] input) {
        PEIntegration.LOG.info("Testing CraftTweaker Support: {}", (Object)output.getDisplayName());
        CraftTweakerAPI.apply((IAction)new AddConversion(output, input));
    }

    private static class AddConversion
    implements IAction {
        private final IItemStack item;
        private final ILiquidStack fluid;
        private final IIngredient[] ingredients;

        protected AddConversion(IItemStack output, IIngredient[] input) {
            this.item = output;
            this.ingredients = input;
            this.fluid = null;
        }

        protected AddConversion(ILiquidStack output, IIngredient[] input) {
            this.fluid = output;
            this.ingredients = input;
            this.item = null;
        }

        public void apply() {
            ItemStack output;
            IngredientMap map = new IngredientMap();
            for (IIngredient ingredient : this.ingredients) {
                Object input = null;
                if (ingredient.getItems().size() == 0 && ingredient.getLiquids().size() > 0) {
                    input = PEIApi.getList(Arrays.asList(CraftTweakerMC.getLiquidStacks((ILiquidStack[])ingredient.getLiquids().toArray(new ILiquidStack[0]))));
                    CraftTweakerMC.getFluid(null);
                } else if (ingredient.getItems().size() > 0) {
                    input = PEIApi.getIngredient(CraftTweakerMC.getIngredient((IIngredient)ingredient));
                }
                map.addIngredient(input, ingredient.getAmount());
            }
            if (this.item != null) {
                output = CraftTweakerMC.getItemStack((IItemStack)this.item);
                ProjectEAPI.getConversionProxy().addConversion(output.func_190916_E(), (Object)output, map.getMap());
            } else if (this.fluid != null) {
                output = CraftTweakerMC.getLiquidStack((ILiquidStack)this.fluid);
                ProjectEAPI.getConversionProxy().addConversion(output.amount, (Object)output, map.getMap());
            }
        }

        public String describe() {
            return "Add your own custom conversion to ProjectE for any custom non supported crafting mechanics";
        }
    }
}

