/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api.utils;

import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.internal.SizedIngredient;
import java.util.Arrays;
import java.util.List;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ClassUtils;

public class Utils {
    public static boolean isSameItem(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == stack1.func_77952_i());
    }

    public static IngredientMap<Object> createInputs(Object ... inputs) {
        return Utils.getInputsFirst((IngredientMap<Object>)new IngredientMap(), inputs);
    }

    public static IngredientMap<Object> getInputsFirst(IngredientMap<Object> ingredients, Object ... inputs) {
        for (Object input : inputs) {
            if (input == null) continue;
            if (input instanceof ItemStack) {
                if (((ItemStack)input).func_190926_b()) continue;
                ingredients.addIngredient(input, ((ItemStack)input).func_190916_E());
                continue;
            }
            if (input instanceof Item || input instanceof Block || input instanceof String || input.getClass().equals(Object.class)) {
                ingredients.addIngredient(input, 1);
                continue;
            }
            if (input instanceof FluidStack) {
                if (((FluidStack)input).amount <= 0) continue;
                ingredients.addIngredient(input, ((FluidStack)input).amount);
                continue;
            }
            if (input instanceof List) {
                List inputt = (List)input;
                if (inputt.isEmpty()) continue;
                if (inputt.size() == 1) {
                    Utils.getInputsFirst(ingredients, inputt.get(0));
                    continue;
                }
                ingredients.addIngredient(PEIApi.getList((List)input), 1);
                continue;
            }
            if (input instanceof Ingredient) {
                if (input == Ingredient.field_193370_a) continue;
                ingredients.addIngredient(PEIApi.getIngredient((Ingredient)input), 1);
                continue;
            }
            if (input instanceof SizedIngredient) {
                SizedIngredient inp = (SizedIngredient)input;
                if (inp.object == Ingredient.field_193370_a) continue;
                ingredients.addIngredient(PEIApi.getIngredient((Ingredient)inp.object), inp.amount);
                continue;
            }
            if (input instanceof Object[]) {
                PEIApi.LOG.debug("Found Array within Array: {} within {}", input, (Object)inputs);
                Utils.getInputsSecond(ingredients, (Object[])input);
                continue;
            }
            PEIApi.LOG.warn("Unknown Input: {} ({})", input, (Object)ClassUtils.getPackageCanonicalName(input.getClass()));
        }
        return ingredients;
    }

    public static IngredientMap<Object> getInputsSecond(IngredientMap<Object> ingredients, Object ... inputs) {
        for (Object input : inputs) {
            if (input == null) continue;
            if (input instanceof ItemStack) {
                if (((ItemStack)input).func_190926_b()) continue;
                ingredients.addIngredient(input, ((ItemStack)input).func_190916_E());
                continue;
            }
            if (input instanceof Item || input instanceof Block || input instanceof String || input.getClass().equals(Object.class)) {
                ingredients.addIngredient(input, 1);
                continue;
            }
            if (input instanceof FluidStack) {
                if (((FluidStack)input).amount <= 0) continue;
                ingredients.addIngredient(input, ((FluidStack)input).amount);
                continue;
            }
            if (input instanceof List) {
                List inputt = (List)input;
                if (inputt.isEmpty()) continue;
                if (inputt.size() == 1) {
                    Utils.getInputsFirst(ingredients, inputt.get(0));
                    continue;
                }
                ingredients.addIngredient(PEIApi.getList((List)input), 1);
                continue;
            }
            if (input instanceof Ingredient) {
                if (input == Ingredient.field_193370_a) continue;
                ingredients.addIngredient(PEIApi.getIngredient((Ingredient)input), 1);
                continue;
            }
            if (input instanceof Object[]) {
                PEIApi.LOG.debug("Found Array within Array: {} within {}", input, (Object)inputs);
                Utils.getInputsFirst(ingredients, Arrays.asList(input));
                continue;
            }
            PEIApi.LOG.warn("Unknown Input: {} ({})", input, (Object)ClassUtils.getPackageCanonicalName(input.getClass()));
        }
        return ingredients;
    }
}

