/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api;

import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import com.tagnumelite.projecteintegration.api.utils.ConfigHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public abstract class PEIPlugin {
    public final String modid;
    public final Configuration config;
    public final String category;

    public PEIPlugin(String modid, Configuration config) {
        this.modid = modid;
        this.config = config;
        this.category = ConfigHelper.getPluginCategory(modid);
    }

    public abstract void setup() throws Exception;

    protected void addEMC(String ore, int base_emc, String extra) {
        int emc = this.config.getInt("emc_ore_" + ore, this.category, base_emc, -1, Integer.MAX_VALUE, extra);
        for (ItemStack item : OreDictionary.getOres((String)ore)) {
            this.setEMC(item, emc);
        }
    }

    protected void addEMC(Item item, int meta, int base_emc) {
        this.addEMC(new ItemStack(item, 1, meta), base_emc);
    }

    protected void addEMC(Item item, int base_emc) {
        this.addEMC(new ItemStack(item), base_emc);
    }

    protected void addEMC(ItemStack item, int base_emc) {
        this.addEMC(item, base_emc, "");
    }

    protected void addEMC(ItemStack item, int base_emc, String extra) {
        if (item == null) {
            return;
        }
        this.setEMC(item, this.config.getInt("emc_item_" + item.func_77977_a(), this.category, base_emc, -1, Integer.MAX_VALUE, "Set the EMC for the item '" + item.func_82833_r() + "' " + extra));
    }

    protected void addEMC(String name, Object obj, int base_emc) {
        this.addEMC(name, obj, base_emc, "");
    }

    protected void addEMC(String name, Object obj, int base_emc, String extra) {
        if (obj == null) {
            return;
        }
        this.setEMC(obj, this.config.getInt("emc_" + name.toLowerCase(), this.category, base_emc, -1, Integer.MAX_VALUE, "Set the EMC value for " + name + ' ' + extra));
    }

    private void setEMC(Object obj, int emc) {
        if (emc <= 0 || obj == null) {
            return;
        }
        PEIApi.addEMCObject(obj, emc);
    }

    protected void addMapper(PEIMapper mapper) {
        if (this.config.getBoolean("enable_" + mapper.name.toLowerCase().replace(' ', '_') + "_mapper", this.category, !mapper.disabled_by_default, mapper.desc)) {
            PEIApi.addMapper(mapper);
        }
    }
}

