/*
 * Decompiled with CFR 0.152.
 */
package worldcontrolteam.worldcontrol.client;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientUtil {
    public static void registerWithMapper(Block block) {
        if (block != null && block.getRegistryName() != null) {
            String resourcePath = block.getRegistryName().toString();
            ClientUtil.setCustomStateMapper(block, state -> new ModelResourceLocation(resourcePath, ClientUtil.getPropertyString(state.func_177228_b(), new String[0])));
            NonNullList subBlocks = NonNullList.func_191196_a();
            block.func_149666_a(null, subBlocks);
            for (ItemStack stack : subBlocks) {
                IBlockState state2 = block.func_176203_a(stack.func_77960_j());
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, ClientUtil.getPropertyString(state2.func_177228_b(), new String[0])));
            }
        }
    }

    public static void setCustomStateMapper(Block block, StateMapper mapper) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper.getMapper());
    }

    public static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> comparable) {
        return property.func_177702_a(comparable);
    }

    public static String getPropertyString(Map<IProperty<?>, Comparable<?>> values, String ... extrasArgs) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> iProperty = entry.getKey();
            stringbuilder.append(iProperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(ClientUtil.getPropertyName(iProperty, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("inventory");
        }
        for (String args : extrasArgs) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            stringbuilder.append(args);
        }
        return stringbuilder.toString();
    }

    public static void registerToNormalWithoutMapper(Block block) {
        String resourcePath = block.getRegistryName().toString();
        NonNullList subBlocks = NonNullList.func_191196_a();
        block.func_149666_a(null, subBlocks);
        for (ItemStack stack : subBlocks) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, "inventory"));
        }
    }

    public static void registerToNormal(Block block) {
        final String resourcePath = block.getRegistryName().toString();
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(resourcePath, "normal");
            }
        });
        NonNullList subBlocks = NonNullList.func_191196_a();
        block.func_149666_a(null, subBlocks);
        for (ItemStack stack : subBlocks) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(resourcePath, "inventory"));
        }
    }

    public static interface StateMapper {
        public ModelResourceLocation getModelResourceLocation(IBlockState var1);

        default public IStateMapper getMapper() {
            return new DefaultStateMapper(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return this.getModelResourceLocation(state);
                }
            };
        }
    }
}

